/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;

public class MD5Filter
implements ISOFilter,
Configurable {
    String key;
    int[] fields;

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.key = cfg.get("key");
        String fieldList = cfg.get("fields");
        if (fieldList == null) {
            throw new ConfigurationException("'fields' property not present");
        }
        StringTokenizer st = new StringTokenizer(fieldList);
        int[] f = new int[st.countTokens()];
        for (int i = 0; i < f.length; ++i) {
            f[i] = Integer.parseInt(st.nextToken());
        }
        this.fields = f;
    }

    public void setFields(int[] fields) {
        this.fields = fields;
    }

    public int[] getFields(ISOMsg m) {
        return this.fields;
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        if (this.key == null || this.fields == null) {
            throw new ISOFilter.VetoException("MD5Filter not configured");
        }
        try {
            int[] f;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.getKey());
            for (int fld : f = this.getFields(m)) {
                if (!m.hasField(fld)) continue;
                ISOComponent c = m.getComponent(fld);
                if (c instanceof ISOBinaryField) {
                    md.update((byte[])c.getValue());
                    continue;
                }
                md.update(((String)c.getValue()).getBytes());
            }
            byte[] digest = md.digest();
            if (m.getDirection() == 2) {
                m.set(new ISOBinaryField(64, digest, 0, 8));
                m.set(new ISOBinaryField(128, digest, 8, 8));
            } else {
                byte[] rxDigest = new byte[16];
                if (m.hasField(64)) {
                    System.arraycopy(m.getValue(64), 0, rxDigest, 0, 8);
                }
                if (m.hasField(128)) {
                    System.arraycopy(m.getValue(128), 0, rxDigest, 8, 8);
                }
                if (!Arrays.equals(digest, rxDigest)) {
                    evt.addMessage(m);
                    evt.addMessage("MAC expected: " + ISOUtil.hexString(digest));
                    evt.addMessage("MAC received: " + ISOUtil.hexString(rxDigest));
                    throw new ISOFilter.VetoException("invalid MAC");
                }
                m.unset(64);
                m.unset(128);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ISOFilter.VetoException(e);
        }
        catch (ISOException e) {
            throw new ISOFilter.VetoException(e);
        }
        return m;
    }

    protected byte[] getKey() {
        return this.key.getBytes();
    }
}

