/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.util.LogEvent;

public class DelayFilter
implements ISOFilter,
Configurable {
    int delay;

    public DelayFilter() {
        this.delay = 0;
    }

    public DelayFilter(int delay) {
        this.delay = delay;
    }

    @Override
    public void setConfiguration(Configuration cfg) {
        this.delay = cfg.getInt("delay");
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) {
        evt.addMessage("<delay-filter delay=\"" + this.delay + "\"/>");
        if (this.delay > 0) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return m;
    }
}

