/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.filter;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.util.LogEvent;

public class ChannelInfoFilter
implements ISOFilter,
Configurable {
    int channelNameField;
    int socketInfoField;

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.channelNameField = cfg.getInt("channel-name", 0);
        this.socketInfoField = cfg.getInt("socket-info", 0);
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) {
        try {
            if (this.channelNameField > 0) {
                m.set(Integer.toString(this.channelNameField), channel.getName());
            }
            if (this.socketInfoField > 0 && channel instanceof BaseChannel) {
                Socket socket = ((BaseChannel)channel).getSocket();
                InetSocketAddress remoteAddr = (InetSocketAddress)socket.getRemoteSocketAddress();
                InetSocketAddress localAddr = (InetSocketAddress)socket.getLocalSocketAddress();
                StringBuilder sb = new StringBuilder();
                if (this.channelNameField == this.socketInfoField) {
                    sb.append(channel.getName());
                    sb.append(' ');
                }
                sb.append(localAddr.getAddress().getHostAddress());
                sb.append(':');
                sb.append(Integer.toString(localAddr.getPort()));
                sb.append(' ');
                sb.append(remoteAddr.getAddress().getHostAddress());
                sb.append(':');
                sb.append(Integer.toString(remoteAddr.getPort()));
                m.set(Integer.toString(this.socketInfoField), sb.toString());
            }
        }
        catch (ISOException e) {
            evt.addMessage(e);
        }
        return m;
    }
}

