/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;

public class XMLChannel
extends BaseChannel {
    BufferedReader reader = null;

    public XMLChannel() {
    }

    public XMLChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public XMLChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public XMLChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected byte[] streamReceive() throws IOException {
        int sp = 0;
        StringBuilder sb = new StringBuilder();
        while (this.reader != null) {
            String s = this.reader.readLine();
            if (s == null) {
                throw new EOFException();
            }
            sb.append(s);
            if (s.contains("<isomsg")) {
                ++sp;
            }
            if (!s.contains("</isomsg>") || --sp > 0) continue;
            break;
        }
        return sb.toString().getBytes();
    }

    @Override
    protected int getHeaderLength() {
        return 0;
    }

    @Override
    protected void sendMessageHeader(ISOMsg m, int len) {
    }

    @Override
    protected void connect(Socket socket) throws IOException {
        super.connect(socket);
        this.reader = new BufferedReader(new InputStreamReader(this.serverIn));
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }
}

