/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;

public class X25Channel
extends BaseChannel {
    BufferedReader reader = null;
    protected byte[] header;

    public X25Channel() {
    }

    public X25Channel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public X25Channel(ISOPackager p) throws IOException {
        super(p);
    }

    public X25Channel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected byte[] streamReceive() throws IOException {
        int k = 0;
        int len = 1;
        Vector<byte[]> v = new Vector<byte[]>();
        int c = this.serverIn.read();
        if (c == -1) {
            throw new EOFException("connection closed");
        }
        byte[] b = new byte[]{(byte)c};
        v.addElement(b);
        while ((c = this.serverIn.available()) > 0) {
            b = new byte[c];
            if (this.serverIn.read(b) != c) {
                throw new EOFException("connection closed");
            }
            v.addElement(b);
            len += c;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        byte[] d = new byte[len];
        for (int i = 0; i < v.size(); ++i) {
            b = (byte[])v.elementAt(i);
            System.arraycopy(b, 0, d, k, b.length);
            k += b.length;
        }
        return d;
    }

    @Override
    protected void connect(Socket socket) throws IOException {
        super.connect(socket);
        this.reader = new BufferedReader(new InputStreamReader(this.serverIn));
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.reader = null;
    }

    @Override
    protected int getHeaderLength() {
        return this.header != null ? this.header.length : 0;
    }

    @Override
    public void setHeader(byte[] header) {
        this.header = header;
    }

    @Override
    public void setHeader(String header) {
        this.setHeader(ISOUtil.hex2byte(header.getBytes(), 0, header.getBytes().length / 2));
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    @Override
    protected void sendMessageHeader(ISOMsg m, int len) throws IOException {
        if (m.getHeader() != null) {
            this.serverOut.write(m.getHeader());
        } else if (this.header != null) {
            this.serverOut.write(this.header);
        }
    }
}

