/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOHeader;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.header.BASE1Header;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class VAPChannel
extends BaseChannel {
    String srcid = "000000";
    String dstid = "000000";
    boolean debugPoll;
    int headerFormat = 2;

    public VAPChannel() {
    }

    public VAPChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public VAPChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public VAPChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    public void setSrcId(String srcid) {
        this.srcid = srcid;
    }

    public String getSrcId() {
        return this.srcid;
    }

    public void setDstId(String dstid) {
        this.dstid = dstid;
    }

    public String getDstId() {
        return this.dstid;
    }

    @Override
    protected ISOHeader getDynamicHeader(byte[] image) {
        return new BASE1Header(image);
    }

    @Override
    protected byte[] readHeader(int hLen) throws IOException {
        int b;
        int bytesRead = b = this.serverIn.read();
        if (b != -1) {
            byte[] bytes = new byte[b];
            bytes[0] = (byte)b;
            this.serverIn.readFully(bytes, 1, b - 1);
            if ((bytes[1] & 0x80) == 128) {
                b = this.serverIn.read();
                byte[] tmp = new byte[bytesRead += b];
                System.arraycopy(bytes, 0, tmp, 0, bytes.length);
                tmp[bytes.length] = (byte)b;
                this.serverIn.readFully(tmp, bytes.length + 1, b - 1);
                bytes = tmp;
            }
            return bytes;
        }
        throw new IOException("Error reading header");
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(len >> 8);
        this.serverOut.write(len);
        this.serverOut.write(0);
        this.serverOut.write(0);
    }

    @Override
    protected void sendMessageHeader(ISOMsg m, int len) throws IOException {
        ISOHeader h;
        ISOHeader iSOHeader = h = !this.isOverrideHeader() && m.getHeader() != null ? m.getISOHeader() : new BASE1Header(this.srcid, this.dstid, this.headerFormat);
        if (h instanceof BASE1Header) {
            ((BASE1Header)h).setLen(len);
        }
        this.serverOut.write(h.pack());
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int l = 0;
        byte[] b = new byte[4];
        while (l == 0) {
            this.serverIn.readFully(b, 0, 4);
            l = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            if (l != 0) continue;
            this.serverOut.write(b);
            this.serverOut.flush();
            if (!this.debugPoll) continue;
            Logger.log(new LogEvent(this, "poll"));
        }
        return l;
    }

    @Override
    protected int getHeaderLength() {
        return 22;
    }

    @Override
    protected boolean isRejected(byte[] b) {
        BASE1Header h = new BASE1Header(b);
        return h.isRejected() || h.getHLen() != 22;
    }

    @Override
    protected boolean shouldIgnore(byte[] b) {
        if (b != null) {
            BASE1Header h = new BASE1Header(b);
            return h.getFormat() > 2;
        }
        return false;
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        if (m.isIncoming() && m.getHeader() != null) {
            BASE1Header h = new BASE1Header(m.getHeader());
            h.swapDirection();
        }
        super.send(m);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.srcid = cfg.get("srcid", "000000");
        this.dstid = cfg.get("dstid", "000000");
        this.debugPoll = cfg.getBoolean("debug-poll", false);
        this.headerFormat = cfg.getInt("header-format", 2);
        super.setConfiguration(cfg);
    }
}

