/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;

public class TelnetXMLChannel
extends BaseChannel {
    BufferedReader reader = null;
    static final String isomsgStartTag = "<isomsg>";
    static final String isomsgEndTag = "</isomsg>";

    public TelnetXMLChannel() {
    }

    public TelnetXMLChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public TelnetXMLChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public TelnetXMLChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected byte[] streamReceive() throws IOException {
        int sp = 0;
        StringBuilder sb = new StringBuilder();
        while (this.reader != null) {
            this.reader.mark(3);
            while (this.reader.read() == 255) {
                this.reader.skip(2L);
                this.reader.mark(3);
            }
            this.reader.reset();
            String s = this.reader.readLine();
            if (s == null) {
                throw new EOFException();
            }
            int isomsgStart = s.indexOf(isomsgStartTag);
            if (isomsgStart >= 0) {
                ++sp;
                sb.append(s, isomsgStart, s.length() - isomsgStart);
                continue;
            }
            int isomsgEnd = s.indexOf(isomsgEndTag);
            if (isomsgEnd >= 0) {
                sb.append(s, 0, isomsgEnd + isomsgEndTag.length());
                if (--sp > 0) continue;
                break;
            }
            if (sp <= 0) continue;
            sb.append(s);
        }
        return sb.toString().getBytes();
    }

    @Override
    protected int getHeaderLength() {
        return 0;
    }

    @Override
    protected void sendMessageHeader(ISOMsg m, int len) {
    }

    @Override
    protected void connect(Socket socket) throws IOException {
        super.connect(socket);
        this.reader = new BufferedReader(new InputStreamReader(this.serverIn));
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }
}

