/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;

public class RawChannel
extends BaseChannel {
    public RawChannel() {
    }

    public RawChannel(String host, int port, ISOPackager p, byte[] header) {
        super(host, port, p);
        this.header = header;
    }

    public RawChannel(ISOPackager p, byte[] header) throws IOException {
        super(p);
        this.header = header;
    }

    public RawChannel(ISOPackager p, byte[] header, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
        this.header = header;
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(len >> 24);
        this.serverOut.write(len >> 16);
        this.serverOut.write(len >> 8);
        this.serverOut.write(len);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        byte[] b = new byte[4];
        this.serverIn.readFully(b, 0, 4);
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    @Override
    public void setHeader(String header) {
        super.setHeader(ISOUtil.str2bcd(header, false));
    }
}

