/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;

public class PostChannel
extends BaseChannel {
    public PostChannel() {
    }

    public PostChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public PostChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public PostChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(len >> 8);
        this.serverOut.write(len);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        byte[] b = new byte[2];
        this.serverIn.readFully(b, 0, 2);
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    @Override
    public void setHeader(String header) {
        super.setHeader(ISOUtil.hex2byte(header.getBytes(), 0, header.length() / 2));
    }
}

