/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class PADChannel
extends BaseChannel {
    BufferedReader reader = null;
    long delay = 0L;

    public PADChannel() {
    }

    public PADChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public PADChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public PADChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
        if (this.delay > 0L) {
            ISOUtil.sleep(this.delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOMsg receive() throws IOException, ISOException {
        byte[] header = null;
        ISOMsg m = new ISOMsg();
        m.setPackager(this.packager);
        m.setSource(this);
        int hLen = this.getHeaderLength();
        LogEvent evt = new LogEvent(this, "receive");
        try {
            Object object = this.serverInLock;
            synchronized (object) {
                if (hLen > 0) {
                    header = new byte[hLen];
                    this.serverIn.readFully(header);
                }
                m.unpack(this.serverIn);
            }
            m.setHeader(header);
            m.setDirection(1);
            m = this.applyIncomingFilters(m, evt);
            m.setDirection(1);
            evt.addMessage(m);
            this.cnt[2] = this.cnt[2] + 1;
            this.setChanged();
            this.notifyObservers(m);
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (EOFException e) {
            evt.addMessage("<peer-disconnect/>");
            throw e;
        }
        catch (InterruptedIOException e) {
            evt.addMessage("<io-timeout/>");
            throw e;
        }
        catch (IOException e) {
            if (this.usable) {
                evt.addMessage(e);
            }
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException("unexpected exception", e);
        }
        finally {
            Logger.log(evt);
        }
        Logger.log(evt);
        return m;
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        super.send(m);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        this.delay = cfg.getLong("delay", 0L);
    }

    @Override
    public void setHeader(String header) {
        super.setHeader(ISOUtil.hex2byte(header.getBytes(), 0, header.length() / 2));
    }
}

