/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import org.jpos.iso.FilteredBase;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.util.BlockingQueue;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;

public class LoopbackChannel
extends FilteredBase
implements LogSource {
    boolean usable = true;
    private int[] cnt = new int[3];
    String name;
    BlockingQueue queue = new BlockingQueue();
    Logger logger;
    String realm;

    @Override
    public void setPackager(ISOPackager packager) {
    }

    @Override
    public void connect() {
        this.cnt[0] = this.cnt[0] + 1;
        this.usable = true;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void disconnect() {
        this.usable = false;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void reconnect() {
        this.usable = true;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean isConnected() {
        return this.usable;
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException, ISOFilter.VetoException {
        if (!this.isConnected()) {
            throw new ISOException("unconnected ISOChannel");
        }
        LogEvent evt = new LogEvent(this, "loopback-send", m);
        m = this.applyOutgoingFilters(m, evt);
        this.queue.enqueue(m);
        this.cnt[1] = this.cnt[1] + 1;
        this.notifyObservers();
        Logger.log(evt);
    }

    @Override
    public void send(byte[] b) throws IOException, ISOException, ISOFilter.VetoException {
        if (!this.isConnected()) {
            throw new ISOException("unconnected ISOChannel");
        }
        LogEvent evt = new LogEvent(this, "loopback-send", b);
        this.queue.enqueue(b);
        this.cnt[1] = this.cnt[1] + 1;
        this.notifyObservers();
        Logger.log(evt);
    }

    @Override
    public ISOMsg receive() throws IOException, ISOException {
        if (!this.isConnected()) {
            throw new ISOException("unconnected ISOChannel");
        }
        try {
            ISOMsg m = (ISOMsg)((ISOMsg)this.queue.dequeue()).clone();
            LogEvent evt = new LogEvent(this, "loopback-receive", m);
            m = this.applyIncomingFilters(m, evt);
            this.cnt[2] = this.cnt[2] + 1;
            this.notifyObservers();
            Logger.log(evt);
            return m;
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        catch (BlockingQueue.Closed e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void setUsable(boolean usable) {
        this.usable = usable;
        this.setChanged();
        this.notifyObservers();
    }

    public int[] getCounters() {
        return this.cnt;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("channel." + name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ISOPackager getPackager() {
        return null;
    }

    public void resetCounters() {
        for (int i = 0; i < 3; ++i) {
            this.cnt[i] = 0;
        }
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

