/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOPackager;

public class LogChannel
extends BaseChannel {
    BufferedReader reader = null;

    public LogChannel() {
    }

    public LogChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public LogChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public LogChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected byte[] streamReceive() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean inMsg = false;
        while (this.reader != null) {
            String s = this.reader.readLine();
            if (s == null) {
                throw new EOFException();
            }
            if (s.contains("<isomsg")) {
                inMsg = true;
            }
            if (inMsg) {
                sb.append(s);
            }
            if (!s.contains("</isomsg>")) continue;
            break;
        }
        return sb.toString().getBytes();
    }

    @Override
    protected int getHeaderLength() {
        return 0;
    }

    @Override
    protected void connect(Socket socket) throws IOException {
        super.connect(socket);
        this.reader = new BufferedReader(new InputStreamReader(this.serverIn));
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.reader = null;
    }
}

