/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class HEXChannel
extends BaseChannel {
    public HEXChannel() {
    }

    public HEXChannel(String host, int port, ISOPackager p, byte[] TPDU) {
        super(host, port, p);
        this.header = TPDU;
    }

    public HEXChannel(ISOPackager p, byte[] TPDU) throws IOException {
        super(p);
        this.header = TPDU;
    }

    public HEXChannel(ISOPackager p, byte[] TPDU, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
        this.header = TPDU;
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        if (len > 65535) {
            throw new IOException(len + " exceeds maximum length");
        }
        try {
            this.serverOut.write(ISOUtil.zeropad(Integer.toString(len % 65535, 16), 4).getBytes());
        }
        catch (ISOException e) {
            Logger.log(new LogEvent(this, "send-message-length", e));
        }
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        byte[] b = new byte[4];
        this.serverIn.readFully(b, 0, 4);
        return Integer.parseInt(new String(b), 16);
    }
}

