/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;

public class GZIPChannel
extends BaseChannel {
    public GZIPChannel() {
    }

    public GZIPChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public GZIPChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public GZIPChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(len >> 8);
        this.serverOut.write(len);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int l = 0;
        byte[] b = new byte[4];
        while (l == 0) {
            this.serverIn.readFully(b, 0, 2);
            l = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            if (l != 0) continue;
            this.serverOut.write(b);
            this.serverOut.flush();
        }
        return l;
    }

    @Override
    protected void sendMessage(byte[] b, int offset, int len) throws IOException {
        GZIPOutputStream gzip = new GZIPOutputStream(this.serverOut);
        gzip.write(b, offset, len);
        gzip.finish();
        gzip.flush();
    }

    @Override
    protected void getMessage(byte[] b, int offset, int len) throws IOException, ISOException {
        int total = 0;
        GZIPInputStream gzip = new GZIPInputStream(this.serverIn);
        while (total < len) {
            int nread = gzip.read(b, offset, len - total);
            if (nread == -1) {
                throw new ISOException("End of compressed stream reached before all data was read");
            }
            total += nread;
            offset += nread;
        }
    }
}

