/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.nio.charset.Charset;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.FSDISOMsg;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.channel.NACChannel;
import org.jpos.util.FSDMsg;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class FSDChannel
extends NACChannel {
    String schema;
    Charset charset;

    @Override
    public ISOMsg createMsg() {
        FSDMsg fsdmsg = new FSDMsg(this.schema);
        fsdmsg.setCharset(this.charset);
        return new FSDISOMsg(fsdmsg);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        this.schema = cfg.get("schema");
        this.charset = Charset.forName(cfg.get("charset", "ISO8859_1"));
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        if (m instanceof FSDISOMsg) {
            FSDMsg fsd = ((FSDISOMsg)m).getFSDMsg();
            fsd.setCharset(this.charset);
        }
        super.send(m);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int len = super.getMessageLength();
        LogEvent evt = new LogEvent(this, "fsd-channel-debug");
        evt.addMessage("received message length: " + len);
        Logger.log(evt);
        return len;
    }
}

