/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;

public class ChannelPool
implements ISOChannel,
LogSource,
Configurable,
Cloneable {
    boolean usable = true;
    String name = "";
    protected Logger logger;
    protected String realm;
    Configuration cfg = null;
    List pool = new Vector();
    ISOChannel current;

    @Override
    public void setPackager(ISOPackager p) {
    }

    @Override
    public synchronized void connect() throws IOException {
        this.current = null;
        LogEvent evt = new LogEvent(this, "connect");
        evt.addMessage("pool-size=" + Integer.toString(this.pool.size()));
        for (int i = 0; i < this.pool.size(); ++i) {
            try {
                evt.addMessage("pool-" + Integer.toString(i));
                ISOChannel c = (ISOChannel)this.pool.get(i);
                c.connect();
                if (!c.isConnected()) continue;
                this.current = c;
                this.usable = true;
                break;
            }
            catch (IOException e) {
                evt.addMessage(e);
            }
        }
        if (this.current == null) {
            evt.addMessage("connect failed");
        }
        Logger.log(evt);
        if (this.current == null) {
            throw new IOException("unable to connect");
        }
    }

    @Override
    public synchronized void disconnect() throws IOException {
        this.current = null;
        LogEvent evt = new LogEvent(this, "disconnect");
        for (Object aPool : this.pool) {
            try {
                ISOChannel c = (ISOChannel)aPool;
                c.disconnect();
            }
            catch (IOException e) {
                evt.addMessage(e);
            }
        }
        Logger.log(evt);
    }

    @Override
    public synchronized void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    @Override
    public synchronized boolean isConnected() {
        try {
            return this.getCurrent().isConnected();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public ISOMsg receive() throws IOException, ISOException {
        return this.getCurrent().receive();
    }

    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        this.getCurrent().send(m);
    }

    @Override
    public void send(byte[] b) throws IOException, ISOException {
        this.getCurrent().send(b);
    }

    @Override
    public void setUsable(boolean b) {
        this.usable = b;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("channel." + name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ISOPackager getPackager() {
        return null;
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void setConfiguration(Configuration cfg) throws ConfigurationException {
        String[] channelName;
        this.cfg = cfg;
        for (String aChannelName : channelName = cfg.getAll("channel")) {
            try {
                this.addChannel(aChannelName);
            }
            catch (NameRegistrar.NotFoundException e) {
                throw new ConfigurationException(e);
            }
        }
    }

    public void addChannel(ISOChannel channel) {
        this.pool.add(channel);
    }

    public void addChannel(String name) throws NameRegistrar.NotFoundException {
        this.pool.add(NameRegistrar.get("channel." + name));
    }

    public void removeChannel(ISOChannel channel) {
        this.pool.remove(channel);
    }

    public void removeChannel(String name) throws NameRegistrar.NotFoundException {
        this.pool.remove(NameRegistrar.get("channel." + name));
    }

    public int size() {
        return this.pool.size();
    }

    public synchronized ISOChannel getCurrent() throws IOException {
        if (this.current == null) {
            this.connect();
        } else if (!this.usable) {
            this.reconnect();
        }
        return this.current;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

