/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class BCDChannel
extends BaseChannel {
    public BCDChannel() {
    }

    public BCDChannel(String host, int port, ISOPackager p, byte[] TPDU) {
        super(host, port, p);
        this.header = TPDU;
    }

    public BCDChannel(ISOPackager p, byte[] TPDU) throws IOException {
        super(p);
        this.header = TPDU;
    }

    public BCDChannel(ISOPackager p, byte[] TPDU, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
        this.header = TPDU;
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        try {
            this.serverOut.write(ISOUtil.str2bcd(ISOUtil.zeropad(Integer.toString(len), 4), true));
        }
        catch (ISOException e) {
            Logger.log(new LogEvent(this, "send-message-length", e));
        }
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        byte[] b = new byte[2];
        this.serverIn.readFully(b, 0, 2);
        return Integer.parseInt(ISOUtil.bcd2str(b, 0, 4, true));
    }

    @Override
    protected void sendMessageHeader(ISOMsg m, int len) throws IOException {
        byte[] h = m.getHeader();
        if (h != null) {
            if (h.length == 5) {
                byte[] tmp = new byte[2];
                System.arraycopy(h, 1, tmp, 0, 2);
                System.arraycopy(h, 3, h, 1, 2);
                System.arraycopy(tmp, 0, h, 3, 2);
            }
        } else {
            h = this.header;
        }
        if (h != null) {
            this.serverOut.write(h);
        }
    }

    @Override
    public void setHeader(String header) {
        super.setHeader(ISOUtil.str2bcd(header, false));
    }
}

