/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class BASE24TCPChannel
extends BaseChannel {
    public BASE24TCPChannel() {
    }

    public BASE24TCPChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public BASE24TCPChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public BASE24TCPChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected void sendMessageTrailler(ISOMsg m, int len) throws IOException {
        this.serverOut.write(3);
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(++len >> 8);
        this.serverOut.write(len);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int l = 0;
        byte[] b = new byte[2];
        Logger.log(new LogEvent(this, "get-message-length"));
        while (l == 0) {
            this.serverIn.readFully(b, 0, 2);
            l = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            if (l != 0) continue;
            this.serverOut.write(b);
            this.serverOut.flush();
        }
        Logger.log(new LogEvent(this, "got-message-length", Integer.toString(l)));
        return l - 1;
    }

    @Override
    protected void getMessageTrailler() throws IOException {
        Logger.log(new LogEvent(this, "get-message-trailler"));
        byte[] b = new byte[1];
        this.serverIn.readFully(b, 0, 1);
        Logger.log(new LogEvent(this, "got-message-trailler", ISOUtil.hexString(b)));
    }
}

