/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class AmexChannel
extends BaseChannel {
    public AmexChannel() {
    }

    public AmexChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public AmexChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public AmexChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        this.serverOut.write(len + 2 >> 8);
        this.serverOut.write(len + 2);
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int l = 0;
        byte[] b = new byte[2];
        while (l == 0) {
            this.serverIn.readFully(b, 0, 2);
            l = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
            if (l != 0) continue;
            this.serverOut.write(b);
            this.serverOut.flush();
            Logger.log(new LogEvent(this, "poll"));
        }
        return l -= 2;
    }
}

