/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso.channel;

import java.io.IOException;
import java.net.ServerSocket;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;

public class ASCIIChannel
extends BaseChannel {
    public ASCIIChannel() {
    }

    public ASCIIChannel(String host, int port, ISOPackager p) {
        super(host, port, p);
    }

    public ASCIIChannel(ISOPackager p) throws IOException {
        super(p);
    }

    public ASCIIChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        super(p, serverSocket);
    }

    @Override
    protected void sendMessageLength(int len) throws IOException {
        if (len > 9999) {
            throw new IOException("len exceeded");
        }
        try {
            this.serverOut.write(ISOUtil.zeropad(Integer.toString(len), 4).getBytes());
        }
        catch (ISOException iSOException) {
            // empty catch block
        }
    }

    @Override
    protected int getMessageLength() throws IOException, ISOException {
        int l = 0;
        byte[] b = new byte[4];
        while (l == 0) {
            this.serverIn.readFully(b, 0, 4);
            try {
                l = Integer.parseInt(new String(b));
                if (l != 0) continue;
                this.serverOut.write(b);
                this.serverOut.flush();
            }
            catch (NumberFormatException e) {
                throw new ISOException("Invalid message length " + new String(b));
            }
        }
        return l;
    }
}

