/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.packager.TagMapper;

public abstract class TaggedFieldPackagerBase
extends ISOFieldPackager {
    private TagMapper tagMapper;
    private ISOFieldPackager delegate;
    private int parentFieldNumber;
    private boolean packingLenient = false;
    private boolean unpackingLenient = false;

    public TaggedFieldPackagerBase() {
    }

    public TaggedFieldPackagerBase(int len, String description) {
        super(len, description);
        this.delegate = this.getDelegate(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        byte[] packed;
        if (c.getValue() == null) {
            packed = new byte[]{};
        } else {
            String tag = this.getTagMapper().getTagForField(this.getParentFieldNumber(), (Integer)c.getKey());
            if (tag == null) {
                if (!this.isPackingLenient()) {
                    throw new ISOException("No tag mapping found for field: " + this.parentFieldNumber + "." + c.getKey());
                }
                packed = new byte[]{};
            } else {
                byte[] tagBytes;
                try {
                    tagBytes = tag.getBytes("ISO8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ISOException(e);
                }
                byte[] message = this.getDelegate().pack(c);
                packed = new byte[tagBytes.length + message.length];
                System.arraycopy(tagBytes, 0, packed, 0, tagBytes.length);
                System.arraycopy(message, 0, packed, tagBytes.length, message.length);
            }
        }
        return packed;
    }

    @Override
    public void pack(ISOComponent c, ObjectOutput out) throws IOException, ISOException {
        if (c.getValue() != null) {
            super.pack(c, out);
        }
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        try {
            int consumed;
            byte[] tagBytes = new byte[this.getTagNameLength()];
            System.arraycopy(b, offset, tagBytes, 0, this.getTagNameLength());
            String tag = new String(tagBytes, "ISO8859_1");
            if (!(c instanceof ISOField)) {
                throw new ISOException(c.getClass().getName() + " is not an ISOField");
            }
            Integer fieldNumber = this.getTagMapper().getFieldNumberForTag(this.getParentFieldNumber(), tag);
            if (fieldNumber == null || fieldNumber < 0) {
                if (!this.isUnpackingLenient()) {
                    throw new ISOException("No field mapping found for tag: " + this.parentFieldNumber + "." + tag);
                }
                consumed = 0;
            } else {
                consumed = c.getKey().equals(fieldNumber) ? this.getTagNameLength() + this.getDelegate().unpack(c, b, offset + tagBytes.length) : 0;
            }
            return consumed;
        }
        catch (UnsupportedEncodingException e) {
            throw new ISOException(e);
        }
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        if (!in.markSupported()) {
            throw new ISOException("InputStream should support marking");
        }
        if (!(c instanceof ISOField)) {
            throw new ISOException(c.getClass().getName() + " is not an ISOField");
        }
        in.mark(this.getTagNameLength() + 1);
        String tag = new String(this.readBytes(in, this.getTagNameLength()), "ISO8859_1");
        Integer fieldNumber = this.getTagMapper().getFieldNumberForTag(this.getParentFieldNumber(), tag);
        if (fieldNumber == null || fieldNumber < 0) {
            if (!this.isUnpackingLenient()) {
                throw new ISOException("No field mapping found for tag: " + this.parentFieldNumber + "." + tag);
            }
            in.reset();
        } else if (c.getKey().equals(fieldNumber)) {
            this.getDelegate().unpack(c, in);
        } else {
            in.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISOFieldPackager getDelegate() {
        if (this.delegate == null) {
            TaggedFieldPackagerBase taggedFieldPackagerBase = this;
            synchronized (taggedFieldPackagerBase) {
                if (this.delegate == null) {
                    this.delegate = this.getDelegate(this.getLength(), this.getDescription());
                }
            }
        }
        return this.delegate;
    }

    protected abstract ISOFieldPackager getDelegate(int var1, String var2);

    protected abstract int getTagNameLength();

    protected boolean isPackingLenient() {
        return this.packingLenient;
    }

    protected boolean isUnpackingLenient() {
        return this.unpackingLenient;
    }

    public void setPackingLenient(boolean packingLenient) {
        this.packingLenient = packingLenient;
    }

    public void setUnpackingLenient(boolean unpackingLenient) {
        this.unpackingLenient = unpackingLenient;
    }

    @Override
    public int getMaxPackedLength() {
        return this.getTagNameLength() + this.getDelegate().getMaxPackedLength();
    }

    public int getParentFieldNumber() {
        return this.parentFieldNumber;
    }

    public void setParentFieldNumber(int parentFieldNumber) {
        this.parentFieldNumber = parentFieldNumber;
    }

    public void setTagMapper(TagMapper tagMapper) {
        this.tagMapper = tagMapper;
    }

    protected TagMapper getTagMapper() {
        return this.tagMapper;
    }
}

