/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOClientSocketFactory;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOServerSocketFactory;
import org.jpos.util.SimpleLogSource;

public class SunJSSESocketFactory
extends SimpleLogSource
implements ISOServerSocketFactory,
ISOClientSocketFactory,
Configurable {
    private SSLContext sslc = null;
    private SSLServerSocketFactory serverFactory = null;
    private SSLSocketFactory socketFactory = null;
    private String keyStore = null;
    private String password = null;
    private String keyPassword = null;
    private String serverName;
    private boolean clientAuthNeeded = false;
    private boolean serverAuthNeeded = false;
    private String[] enabledCipherSuites;
    private Configuration cfg;

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setClientAuthNeeded(boolean clientAuthNeeded) {
        this.clientAuthNeeded = clientAuthNeeded;
    }

    public void setServerAuthNeeded(boolean serverAuthNeeded) {
        this.serverAuthNeeded = serverAuthNeeded;
    }

    private TrustManager[] getTrustManagers(KeyStore ks) throws GeneralSecurityException {
        if (this.serverAuthNeeded) {
            TrustManagerFactory tm = TrustManagerFactory.getInstance("SunX509");
            tm.init(ks);
            return tm.getTrustManagers();
        }
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return new java.security.cert.X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(java.security.cert.X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(java.security.cert.X509Certificate[] certs, String authType) {
            }
        }};
    }

    private SSLContext getSSLContext() throws ISOException {
        if (this.password == null) {
            this.password = this.getPassword();
        }
        if (this.keyPassword == null) {
            this.keyPassword = this.getKeyPassword();
        }
        if (this.keyStore == null || this.keyStore.length() == 0) {
            this.keyStore = System.getProperty("user.home") + File.separator + ".keystore";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(new File(this.keyStore));
            ks.load(fis, this.password.toCharArray());
            fis.close();
            KeyManagerFactory km = KeyManagerFactory.getInstance("SunX509");
            km.init(ks, this.keyPassword.toCharArray());
            KeyManager[] kma = km.getKeyManagers();
            TrustManager[] tma = this.getTrustManagers(ks);
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(kma, tma, SecureRandom.getInstance("SHA1PRNG"));
            SSLContext sSLContext = sslc;
            return sSLContext;
        }
        catch (Exception e) {
            throw new ISOException(e);
        }
        finally {
            this.password = null;
            this.keyPassword = null;
        }
    }

    protected SSLServerSocketFactory createServerSocketFactory() throws ISOException {
        if (this.sslc == null) {
            this.sslc = this.getSSLContext();
        }
        return this.sslc.getServerSocketFactory();
    }

    protected SSLSocketFactory createSocketFactory() throws ISOException {
        if (this.sslc == null) {
            this.sslc = this.getSSLContext();
        }
        return this.sslc.getSocketFactory();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException, ISOException {
        if (this.serverFactory == null) {
            this.serverFactory = this.createServerSocketFactory();
        }
        ServerSocket socket = this.serverFactory.createServerSocket(port);
        SSLServerSocket serverSocket = (SSLServerSocket)socket;
        serverSocket.setNeedClientAuth(this.clientAuthNeeded);
        if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
            serverSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, ISOException {
        if (this.socketFactory == null) {
            this.socketFactory = this.createSocketFactory();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(host, port);
        this.verifyHostname(s);
        return s;
    }

    private void verifyHostname(SSLSocket socket) throws SSLPeerUnverifiedException, UnknownHostException {
        X509Certificate[] certs;
        if (!this.serverAuthNeeded) {
            return;
        }
        SSLSession session = socket.getSession();
        if (this.serverName == null || this.serverName.length() == 0) {
            this.serverName = session.getPeerHost();
            try {
                InetAddress addr = InetAddress.getByName(this.serverName);
            }
            catch (UnknownHostException uhe) {
                throw new UnknownHostException("Could not resolve SSL server name " + this.serverName);
            }
        }
        if ((certs = session.getPeerCertificateChain()) == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found");
        }
        String dn = certs[0].getSubjectDN().getName();
        String cn = this.getCN(dn);
        if (!this.serverName.equalsIgnoreCase(cn)) {
            throw new SSLPeerUnverifiedException("Invalid SSL server name. Expected '" + this.serverName + "', got '" + cn + "'");
        }
    }

    private String getCN(String dn) {
        int i = dn.indexOf("CN=");
        if (i == -1) {
            return null;
        }
        dn = dn.substring(i + 3);
        char[] dncs = dn.toCharArray();
        for (i = 0; i < dncs.length && (dncs[i] != ',' || i <= 0 || dncs[i - 1] == '\\'); ++i) {
        }
        return dn.substring(0, i);
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    protected String getPassword() {
        return System.getProperty("jpos.ssl.storepass", "password");
    }

    protected String getKeyPassword() {
        return System.getProperty("jpos.ssl.keypass", "password");
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean getClientAuthNeeded() {
        return this.clientAuthNeeded;
    }

    public boolean getServerAuthNeeded() {
        return this.serverAuthNeeded;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.keyStore = cfg.get("keystore");
        this.clientAuthNeeded = cfg.getBoolean("clientauth");
        this.serverAuthNeeded = cfg.getBoolean("serverauth");
        this.serverName = cfg.get("servername");
        this.password = cfg.get("storepassword", null);
        this.keyPassword = cfg.get("keypassword", null);
        this.enabledCipherSuites = cfg.getAll("addEnabledCipherSuite");
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    static {
        Security.addProvider((java.security.Provider)new Provider());
    }
}

