/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOUtil;
import org.jpos.iso.Interpreter;

public class SignedEbcdicNumberInterpreter
implements Interpreter {
    public static final SignedEbcdicNumberInterpreter INSTANCE = new SignedEbcdicNumberInterpreter();

    @Override
    public void interpret(String data, byte[] targetArray, int offset) {
        boolean negative = data.startsWith("-");
        if (negative) {
            ISOUtil.asciiToEbcdic(data.substring(1), targetArray, offset);
            targetArray[offset + data.length() - 2] = (byte)(targetArray[offset + data.length() - 2] & 0xDF);
        } else {
            ISOUtil.asciiToEbcdic(data, targetArray, offset);
        }
    }

    @Override
    public String uninterpret(byte[] rawData, int offset, int length) {
        boolean negative = (byte)(rawData[offset + length - 1] & 0xF0) == -48;
        rawData[offset + length - 1] = (byte)(rawData[offset + length - 1] | 0xF0);
        return (negative ? "-" : "") + ISOUtil.ebcdicToAscii(rawData, offset, length);
    }

    @Override
    public int getPackedLength(int nDataUnits) {
        return nDataUnits;
    }
}

