/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOException;
import org.jpos.iso.Padder;

public class RightPadder
implements Padder {
    public static final RightPadder SPACE_PADDER = new RightPadder(' ');
    private char pad;

    public RightPadder(char pad) {
        this.pad = pad;
    }

    @Override
    public String pad(String data, int maxLength) throws ISOException {
        int len = data.length();
        if (len < maxLength) {
            StringBuilder padded = new StringBuilder(maxLength);
            padded.append(data);
            while (len < maxLength) {
                padded.append(this.pad);
                ++len;
            }
            data = padded.toString();
        } else if (len > maxLength) {
            throw new ISOException("Data is too long. Max = " + maxLength);
        }
        return data;
    }

    @Override
    public String unpad(String paddedData) {
        int len;
        for (int i = len = paddedData.length(); i > 0; --i) {
            if (paddedData.charAt(i - 1) == this.pad) continue;
            return paddedData.substring(0, i);
        }
        return "";
    }
}

