/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOException;
import org.jpos.iso.Padder;

public class LeftPadder
implements Padder {
    public static final LeftPadder ZERO_PADDER = new LeftPadder('0');
    private char pad;

    public LeftPadder(char pad) {
        this.pad = pad;
    }

    @Override
    public String pad(String data, int maxLength) throws ISOException {
        StringBuilder padded = new StringBuilder(maxLength);
        int len = data.length();
        if (len > maxLength) {
            throw new ISOException("Data is too long. Max = " + maxLength);
        }
        for (int i = maxLength - len; i > 0; --i) {
            padded.append(this.pad);
        }
        padded.append(data);
        return padded.toString();
    }

    @Override
    public String unpad(String paddedData) {
        int len = paddedData.length();
        for (int i = 0; i < len; ++i) {
            if (paddedData.charAt(i) == this.pad) continue;
            return paddedData.substring(i);
        }
        return "";
    }
}

