/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFieldValidator;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVField;
import org.jpos.iso.validator.ISOVException;

public class IVA_NUM
extends ISOFieldValidator {
    protected int radix = 10;

    public IVA_NUM() {
    }

    public IVA_NUM(String Description) {
        super(Description);
    }

    public IVA_NUM(String Description, int radix) {
        super(Description);
        this.radix = radix;
    }

    public IVA_NUM(int maxLen, String Description) {
        super(maxLen, Description);
    }

    public IVA_NUM(int maxLen, String Description, int radix) {
        super(maxLen, Description);
        this.radix = radix;
    }

    public IVA_NUM(int minLen, int maxLen, String Description) {
        super(minLen, maxLen, Description);
    }

    public IVA_NUM(int minLen, int maxLen, String Description, int radix) {
        super(minLen, maxLen, Description);
        this.radix = radix;
    }

    public IVA_NUM(boolean breakOnError, String Description) {
        this(Description);
        this.breakOnError = breakOnError;
    }

    public IVA_NUM(boolean breakOnError, String Description, int radix) {
        this(Description, radix);
        this.breakOnError = breakOnError;
    }

    public IVA_NUM(boolean breakOnError, int maxLen, String Description) {
        this(maxLen, Description);
        this.breakOnError = breakOnError;
    }

    public IVA_NUM(boolean breakOnError, int maxLen, String Description, int radix) {
        this(maxLen, Description, radix);
        this.breakOnError = breakOnError;
    }

    public IVA_NUM(boolean breakOnError, int minLen, int maxLen, String Description) {
        this(minLen, maxLen, Description);
        this.breakOnError = breakOnError;
    }

    public IVA_NUM(boolean breakOnError, int minLen, int maxLen, String Description, int radix) {
        this(minLen, maxLen, Description, radix);
        this.breakOnError = breakOnError;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        this.radix = cfg.getInt("radix", 10);
    }

    @Override
    public ISOComponent validate(ISOComponent f) throws ISOException {
        ISOField c = (ISOField)f;
        if (!ISOUtil.isNumeric((String)(c = (ISOField)super.validate(c)).getValue(), this.radix)) {
            ISOVError e = new ISOVError("Invalid Value Error. " + c.getValue() + " is not a numeric value in radix " + this.radix, this.getRejCode(2));
            if (c instanceof ISOVField) {
                ((ISOVField)c).addISOVError(e);
            } else {
                c = new ISOVField(c, e);
            }
            if (this.breakOnError) {
                throw new ISOVException("Error on field " + (Integer)c.getKey(), c);
            }
        }
        return c;
    }
}

