/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFieldValidator;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVField;
import org.jpos.iso.validator.ISOVException;

public class IVA_ALPHANUM
extends ISOFieldValidator {
    public IVA_ALPHANUM() {
    }

    public IVA_ALPHANUM(String Description) {
        super(Description);
    }

    public IVA_ALPHANUM(int minLen, int maxLen, String Description) {
        super(minLen, maxLen, Description);
    }

    public IVA_ALPHANUM(int maxLen, String Description) {
        super(maxLen, Description);
    }

    public IVA_ALPHANUM(boolean breakOnError, String Description) {
        this(Description);
        this.breakOnError = breakOnError;
    }

    public IVA_ALPHANUM(boolean breakOnError, int maxLen, String Description) {
        this(maxLen, Description);
        this.breakOnError = breakOnError;
    }

    public IVA_ALPHANUM(boolean breakOnError, int minLen, int maxLen, String Description) {
        this(minLen, maxLen, Description);
        this.breakOnError = breakOnError;
    }

    @Override
    public ISOComponent validate(ISOComponent f) throws ISOException {
        ISOField c = (ISOField)f;
        try {
            c = (ISOField)super.validate(c);
            if (!ISOUtil.isAlphaNumeric((String)c.getValue())) {
                ISOVError e = new ISOVError("Invalid Value Error. " + c.getValue() + " is not an alphanumeric value. ", this.getRejCode(2));
                if (c instanceof ISOVField) {
                    ((ISOVField)c).addISOVError(e);
                } else {
                    c = new ISOVField(c, e);
                }
                if (this.breakOnError) {
                    throw new ISOVException("Error on field " + (Integer)c.getKey(), c);
                }
            }
            return c;
        }
        catch (Exception ex) {
            if (ex instanceof ISOVException) {
                throw (ISOVException)ex;
            }
            return c;
        }
    }
}

