/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.AsciiPrefixer;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.Interpreter;
import org.jpos.iso.LiteralInterpreter;
import org.jpos.iso.NullPrefixer;
import org.jpos.iso.Padder;
import org.jpos.iso.Prefixer;

public class ISOTagStringFieldPackager
extends ISOFieldPackager {
    private Prefixer tagPrefixer;
    private Interpreter interpreter;
    private Padder padder;
    private Prefixer prefixer;

    public ISOTagStringFieldPackager() {
        this.tagPrefixer = AsciiPrefixer.L;
        this.interpreter = LiteralInterpreter.INSTANCE;
        this.prefixer = NullPrefixer.INSTANCE;
    }

    public ISOTagStringFieldPackager(Prefixer tagPrefixer, Padder padder, Interpreter interpreter, Prefixer prefixer) {
        this.tagPrefixer = tagPrefixer;
        this.padder = padder;
        this.interpreter = interpreter;
        this.prefixer = prefixer;
    }

    public ISOTagStringFieldPackager(int maxLength, String description, Prefixer tagPrefixer, Padder padder, Interpreter interpreter, Prefixer prefixer) {
        super(maxLength, description);
        this.tagPrefixer = tagPrefixer;
        this.padder = padder;
        this.interpreter = interpreter;
        this.prefixer = prefixer;
    }

    public void setPadder(Padder padder) {
        this.padder = padder;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setPrefixer(Prefixer prefixer) {
        this.prefixer = prefixer;
    }

    @Override
    public int getMaxPackedLength() {
        return this.tagPrefixer.getPackedLength() + this.prefixer.getPackedLength() + this.interpreter.getPackedLength(this.getLength());
    }

    private String makeExceptionMessage(ISOComponent c, String operation) {
        Object fieldKey = "unknown";
        if (c != null) {
            try {
                fieldKey = c.getKey();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return this.getClass().getName() + ": Problem " + operation + " field " + fieldKey;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        try {
            String data = (String)c.getValue();
            if (data.length() > this.getLength()) {
                throw new ISOException("Field length " + data.length() + " too long. Max: " + this.getLength());
            }
            int tag = (Integer)c.getKey();
            String paddedData = this.padder.pad(data, this.getLength());
            byte[] rawData = new byte[this.tagPrefixer.getPackedLength() + this.prefixer.getPackedLength() + this.interpreter.getPackedLength(paddedData.length())];
            this.tagPrefixer.encodeLength(tag, rawData);
            byte[] rawLen = new byte[this.prefixer.getPackedLength()];
            this.prefixer.encodeLength(paddedData.length(), rawLen);
            System.arraycopy(rawLen, 0, rawData, this.tagPrefixer.getPackedLength(), rawLen.length);
            this.interpreter.interpret(paddedData, rawData, this.tagPrefixer.getPackedLength() + rawLen.length);
            return rawData;
        }
        catch (Exception e) {
            throw new ISOException(this.makeExceptionMessage(c, "packing"), e);
        }
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        try {
            int tagLen = this.tagPrefixer.getPackedLength();
            c.setFieldNumber(this.tagPrefixer.decodeLength(b, offset));
            int len = this.prefixer.decodeLength(b, offset + tagLen);
            if (len == -1) {
                len = this.getLength();
            } else if (this.getLength() > 0 && len > this.getLength()) {
                throw new ISOException("Field length " + len + " too long. Max: " + this.getLength());
            }
            int lenLen = this.prefixer.getPackedLength();
            String unpacked = this.interpreter.uninterpret(b, offset + tagLen + lenLen, len);
            c.setValue(unpacked);
            return tagLen + lenLen + this.interpreter.getPackedLength(len);
        }
        catch (Exception e) {
            throw new ISOException(this.makeExceptionMessage(c, "unpacking"), e);
        }
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        try {
            int len;
            int tagLen = this.tagPrefixer.getPackedLength();
            c.setFieldNumber(this.tagPrefixer.decodeLength(this.readBytes(in, tagLen), 0));
            int lenLen = this.prefixer.getPackedLength();
            if (lenLen == 0) {
                len = this.getLength();
            } else {
                len = this.prefixer.decodeLength(this.readBytes(in, lenLen), 0);
                if (this.getLength() > 0 && len > 0 && len > this.getLength()) {
                    throw new ISOException("Field length " + len + " too long. Max: " + this.getLength());
                }
            }
            int packedLen = this.interpreter.getPackedLength(len);
            String unpacked = this.interpreter.uninterpret(this.readBytes(in, packedLen), 0, len);
            c.setValue(unpacked);
        }
        catch (ISOException e) {
            throw new ISOException(this.makeExceptionMessage(c, "unpacking"), e);
        }
    }
}

