/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Vector;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannel;
import org.jpos.iso.FilteredChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.ISOServerAcceptEvent;
import org.jpos.iso.ISOServerClientDisconnectEvent;
import org.jpos.iso.ISOServerEventListener;
import org.jpos.iso.ISOServerMBean;
import org.jpos.iso.ISOServerShutdownEvent;
import org.jpos.iso.ISOServerSocketFactory;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.ServerChannel;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;
import org.jpos.util.ThreadPool;

public class ISOServer
extends Observable
implements LogSource,
Runnable,
Observer,
ISOServerMBean,
Configurable,
Loggeable,
ISOServerSocketFactory {
    int port;
    protected ISOChannel clientSideChannel;
    ISOPackager clientPackager;
    protected Collection clientOutgoingFilters;
    protected Collection clientIncomingFilters;
    protected Collection listeners;
    ThreadPool pool;
    public static final int DEFAULT_MAX_THREADS = 100;
    public static final String LAST = ":last";
    String name;
    protected long lastTxn = 0L;
    protected Logger logger;
    protected String realm;
    protected String realmChannel;
    protected ISOServerSocketFactory socketFactory = null;
    public static final int CONNECT = 0;
    public static final int SIZEOF_CNT = 1;
    private int[] cnt;
    private String[] allow;
    private InetAddress bindAddr;
    private int backlog;
    protected Configuration cfg;
    private boolean shutdown = false;
    private ServerSocket serverSocket;
    private Map channels;
    protected boolean ignoreISOExceptions;
    protected List<ISOServerEventListener> serverListeners = null;

    public ISOServer(int port, ServerChannel clientSide, ThreadPool pool) {
        this.port = port;
        this.clientSideChannel = clientSide;
        this.clientPackager = clientSide.getPackager();
        if (clientSide instanceof FilteredChannel) {
            FilteredChannel fc = (FilteredChannel)((Object)clientSide);
            this.clientOutgoingFilters = fc.getOutgoingFilters();
            this.clientIncomingFilters = fc.getIncomingFilters();
        }
        this.pool = pool == null ? new ThreadPool(1, 100) : pool;
        this.listeners = new Vector();
        this.name = "";
        this.channels = new HashMap();
        this.cnt = new int[1];
        this.serverListeners = new ArrayList<ISOServerEventListener>();
    }

    protected Session createSession(ServerChannel channel) {
        return new Session(channel);
    }

    public void addISORequestListener(ISORequestListener l) {
        this.listeners.add(l);
    }

    public void removeISORequestListener(ISORequestListener l) {
        this.listeners.remove(l);
    }

    public void shutdown() {
        this.shutdown = true;
        new Thread("ISOServer-shutdown"){

            @Override
            public void run() {
                ISOServer.this.shutdownServer();
                if (!ISOServer.this.cfg.getBoolean("keep-channels")) {
                    ISOServer.this.shutdownChannels();
                }
            }
        }.start();
    }

    private void shutdownServer() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.fireEvent(new ISOServerShutdownEvent(this));
            }
            if (this.pool != null) {
                this.pool.close();
            }
        }
        catch (IOException e) {
            this.fireEvent(new ISOServerShutdownEvent(this));
            Logger.log(new LogEvent(this, "shutdown", e));
        }
    }

    private void shutdownChannels() {
        for (Map.Entry entry : this.channels.entrySet()) {
            WeakReference ref = (WeakReference)entry.getValue();
            ISOChannel c = (ISOChannel)ref.get();
            if (c == null) continue;
            try {
                c.disconnect();
                this.fireEvent(new ISOServerClientDisconnectEvent(this));
            }
            catch (IOException e) {
                Logger.log(new LogEvent(this, "shutdown", e));
            }
        }
    }

    private void purgeChannels() {
        Iterator iter = this.channels.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            ISOChannel c = (ISOChannel)ref.get();
            if (c != null && c.isConnected()) continue;
            iter.remove();
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(this.bindAddr, port), this.backlog);
        }
        catch (SecurityException e) {
            ss.close();
            this.fireEvent(new ISOServerShutdownEvent(this));
            throw e;
        }
        catch (IOException e) {
            ss.close();
            this.fireEvent(new ISOServerShutdownEvent(this));
            throw e;
        }
        return ss;
    }

    @Override
    public void run() {
        if (this.socketFactory == null) {
            this.socketFactory = this;
        }
        block7: while (!this.shutdown) {
            try {
                this.serverSocket = this.socketFactory.createServerSocket(this.port);
                Logger.log(new LogEvent(this, "iso-server", "listening on " + (this.bindAddr != null ? this.bindAddr + ":" : "port ") + this.port + (this.backlog > 0 ? " backlog=" + this.backlog : "")));
                while (!this.shutdown) {
                    try {
                        if (this.pool.getAvailableCount() <= 0) {
                            try {
                                this.serverSocket.close();
                                this.fireEvent(new ISOServerShutdownEvent(this));
                            }
                            catch (IOException e) {
                                Logger.log(new LogEvent(this, "iso-server", e));
                                this.relax();
                            }
                            int i = 0;
                            while (this.pool.getIdleCount() == 0) {
                                if (this.shutdown) break block7;
                                if (i % 240 == 0 && this.cfg.getBoolean("pool-exhaustion-warning", true)) {
                                    LogEvent evt = new LogEvent(this, "warn");
                                    evt.addMessage("pool exhausted " + this.serverSocket.toString());
                                    evt.addMessage(this.pool);
                                    Logger.log(evt);
                                }
                                ISOUtil.sleep(250L);
                                ++i;
                            }
                            this.serverSocket = this.socketFactory.createServerSocket(this.port);
                        }
                        ServerChannel channel = (ServerChannel)this.clientSideChannel.clone();
                        channel.accept(this.serverSocket);
                        int n = this.cnt[0];
                        this.cnt[0] = n + 1;
                        if (n % 100 == 0) {
                            this.purgeChannels();
                        }
                        WeakReference<ServerChannel> wr = new WeakReference<ServerChannel>(channel);
                        this.channels.put(channel.getName(), wr);
                        this.channels.put(LAST, wr);
                        this.pool.execute(this.createSession(channel));
                        this.setChanged();
                        this.notifyObservers(this);
                        this.fireEvent(new ISOServerAcceptEvent(this));
                        if (!(channel instanceof Observable)) continue;
                        ((Observable)((Object)channel)).addObserver(this);
                    }
                    catch (SocketException e) {
                        if (this.shutdown) continue;
                        Logger.log(new LogEvent(this, "iso-server", e));
                        this.relax();
                        continue block7;
                    }
                    catch (IOException e) {
                        Logger.log(new LogEvent(this, "iso-server", e));
                        this.relax();
                    }
                }
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(this, "iso-server", e));
                this.relax();
            }
        }
    }

    private void relax() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("server." + name, this);
    }

    public static ISOServer getServer(String name) throws NameRegistrar.NotFoundException {
        return (ISOServer)NameRegistrar.get("server." + name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
        this.realmChannel = realm + ".channel";
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public ISOServerSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(ISOServerSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void resetCounters() {
        this.cnt = new int[1];
        this.lastTxn = 0L;
    }

    @Override
    public int getConnectionCount() {
        return this.cnt[0];
    }

    @Override
    public int getJobCount() {
        return this.pool.getJobCount();
    }

    @Override
    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    @Override
    public int getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    @Override
    public int getIdleCount() {
        return this.pool.getIdleCount();
    }

    @Override
    public int getPendingCount() {
        return this.pool.getPendingCount();
    }

    public int getActiveConnections() {
        return this.pool.getActiveCount();
    }

    public ISOChannel getLastConnectedISOChannel() {
        return this.getISOChannel(LAST);
    }

    public ISOChannel getISOChannel(String name) {
        WeakReference ref = (WeakReference)this.channels.get(name);
        if (ref != null) {
            return (ISOChannel)ref.get();
        }
        return null;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.allow = cfg.getAll("allow");
        this.backlog = cfg.getInt("backlog", 0);
        this.ignoreISOExceptions = cfg.getBoolean("ignore-iso-exceptions");
        String ip = cfg.get("bind-address", null);
        if (ip != null) {
            try {
                this.bindAddr = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Invalid bind-address " + ip, e);
            }
        }
        if (this.socketFactory == null) {
            this.socketFactory = this;
        }
        if (this.socketFactory != this && this.socketFactory instanceof Configurable) {
            ((Configurable)((Object)this.socketFactory)).setConfiguration(cfg);
        }
    }

    @Override
    public String getISOChannelNames() {
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.channels.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            ISOChannel c = (ISOChannel)ref.get();
            if (c != null && !LAST.equals(entry.getKey()) && c.isConnected()) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(entry.getKey());
            }
            ++i;
        }
        return sb.toString();
    }

    public String getCountersAsString() {
        StringBuilder sb = new StringBuilder();
        int[] cnt = this.getCounters();
        sb.append("connected=");
        sb.append(Integer.toString(cnt[2]));
        sb.append(", rx=");
        sb.append(Integer.toString(cnt[0]));
        sb.append(", tx=");
        sb.append(Integer.toString(cnt[1]));
        sb.append(", last=");
        sb.append(this.lastTxn);
        if (this.lastTxn > 0L) {
            sb.append(", idle=");
            sb.append(System.currentTimeMillis() - this.lastTxn);
            sb.append("ms");
        }
        return sb.toString();
    }

    public int[] getCounters() {
        Iterator iter = this.channels.entrySet().iterator();
        int[] cnt = new int[3];
        cnt[2] = 0;
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            ISOChannel c = (ISOChannel)ref.get();
            if (c != null && !LAST.equals(entry.getKey()) && c.isConnected()) {
                cnt[2] = cnt[2] + 1;
                if (c instanceof BaseChannel) {
                    int[] cc = ((BaseChannel)c).getCounters();
                    cnt[0] = cnt[0] + cc[2];
                    cnt[1] = cnt[1] + cc[1];
                }
            }
            ++i;
        }
        return cnt;
    }

    @Override
    public int getTXCounter() {
        int[] cnt = this.getCounters();
        return cnt[1];
    }

    @Override
    public int getRXCounter() {
        int[] cnt = this.getCounters();
        return cnt[0];
    }

    public int getConnections() {
        int[] cnt = this.getCounters();
        return cnt[2];
    }

    @Override
    public long getLastTxnTimestampInMillis() {
        return this.lastTxn;
    }

    @Override
    public long getIdleTimeInMillis() {
        return this.lastTxn > 0L ? System.currentTimeMillis() - this.lastTxn : -1L;
    }

    @Override
    public String getCountersAsString(String isoChannelName) {
        ISOChannel channel = this.getISOChannel(isoChannelName);
        StringBuffer sb = new StringBuffer();
        if (channel instanceof BaseChannel) {
            int[] counters = ((BaseChannel)channel).getCounters();
            this.append(sb, "rx=", counters[2]);
            this.append(sb, ", tx=", counters[1]);
            this.append(sb, ", connects=", counters[0]);
        }
        return sb.toString();
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + this.getCountersAsString());
        Iterator iter = this.channels.entrySet().iterator();
        String inner = indent + "  ";
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            WeakReference ref = (WeakReference)entry.getValue();
            ISOChannel c = (ISOChannel)ref.get();
            if (c != null && !LAST.equals(entry.getKey()) && c.isConnected() && c instanceof BaseChannel) {
                StringBuilder sb = new StringBuilder();
                int[] cc = ((BaseChannel)c).getCounters();
                sb.append(inner);
                sb.append(entry.getKey());
                sb.append(": rx=");
                sb.append(Integer.toString(cc[2]));
                sb.append(", tx=");
                sb.append(Integer.toString(cc[1]));
                sb.append(", last=");
                sb.append(Long.toString(this.lastTxn));
                p.println(sb.toString());
            }
            ++i;
        }
    }

    private void append(StringBuffer sb, String name, int value) {
        sb.append(name);
        sb.append(value);
    }

    public synchronized void addServerEventListener(ISOServerEventListener listener) {
        this.serverListeners.add(listener);
    }

    public synchronized void removeServerEventListener(ISOServerEventListener listener) {
        this.serverListeners.remove(listener);
    }

    public synchronized void fireEvent(EventObject event) {
        for (ISOServerEventListener l : this.serverListeners) {
            l.handleISOServerEvent(event);
        }
    }

    static /* synthetic */ void access$000(ISOServer x0) {
        x0.setChanged();
    }

    protected class Session
    implements Runnable,
    LogSource {
        ServerChannel channel;
        String realm;

        protected Session(ServerChannel channel) {
            this.channel = channel;
            this.realm = ISOServer.this.getRealm() + ".session";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ISOServer.access$000(ISOServer.this);
            ISOServer.this.notifyObservers();
            if (this.channel instanceof BaseChannel) {
                ev = new LogEvent(this, "session-start");
                socket = ((BaseChannel)this.channel).getSocket();
                this.realm = this.realm + "/" + socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
                try {
                    this.checkPermission(socket, ev);
                }
                catch (ISOException e) {
                    try {
                        delay = 1000 + new Random().nextInt(4000);
                        ev.addMessage(e.getMessage());
                        ev.addMessage("delay=" + delay);
                        ISOUtil.sleep(delay);
                        socket.close();
                        ISOServer.this.fireEvent(new ISOServerShutdownEvent(ISOServer.this));
                    }
                    catch (IOException ioe) {
                        ev.addMessage(ioe);
                    }
                    return;
                }
                finally {
                    Logger.log(ev);
                }
            }
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        while (true) {
                            m = this.channel.receive();
                            ISOServer.this.lastTxn = System.currentTimeMillis();
                            iter = ISOServer.this.listeners.iterator();
                            while (iter.hasNext() && !((ISORequestListener)iter.next()).process(this.channel, m)) {
                            }
                        }
                    }
                    catch (ISOFilter.VetoException e) {
                        Logger.log(new LogEvent(this, "VetoException", e.getMessage()));
                    }
                    catch (ISOException e) {
                        if (ISOServer.this.ignoreISOExceptions) {
                            Logger.log(new LogEvent(this, "ISOException", e.getMessage()));
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            catch (EOFException e) {
            }
            catch (SocketException e) {
            }
            catch (InterruptedIOException e) {
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(this, "session-error", e));
            }
            ** GOTO lbl-1000
            try {
                this.channel.disconnect();
                ISOServer.this.fireEvent(new ISOServerClientDisconnectEvent(ISOServer.this));
            }
            catch (IOException ex) {
                Logger.log(new LogEvent(this, "session-error", ex));
                ISOServer.this.fireEvent(new ISOServerClientDisconnectEvent(ISOServer.this));
            }
            Logger.log(new LogEvent(this, "session-end"));
        }

        @Override
        public void setLogger(Logger logger, String realm) {
        }

        @Override
        public String getRealm() {
            return this.realm;
        }

        @Override
        public Logger getLogger() {
            return ISOServer.this.getLogger();
        }

        public void checkPermission(Socket socket, LogEvent evt) throws ISOException {
            if (ISOServer.this.allow != null && ISOServer.this.allow.length > 0) {
                String ip = socket.getInetAddress().getHostAddress();
                for (String element : ISOServer.this.allow) {
                    if (!ip.equals(element)) continue;
                    evt.addMessage("access granted, ip=" + ip);
                    return;
                }
                throw new ISOException("access denied, ip=" + ip);
            }
        }
    }
}

