/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;

public class ISOMsgFieldPackager
extends ISOFieldPackager {
    protected ISOPackager msgPackager;
    protected ISOFieldPackager fieldPackager;

    public ISOMsgFieldPackager(ISOFieldPackager fieldPackager, ISOPackager msgPackager) {
        super(fieldPackager.getLength(), fieldPackager.getDescription());
        this.msgPackager = msgPackager;
        this.fieldPackager = fieldPackager;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        if (c instanceof ISOMsg) {
            ISOMsg m = (ISOMsg)c;
            m.recalcBitMap();
            ISOBinaryField f = new ISOBinaryField(0, this.msgPackager.pack(m));
            return this.fieldPackager.pack(f);
        }
        return this.fieldPackager.pack(c);
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        ISOBinaryField f = new ISOBinaryField(0);
        int consumed = this.fieldPackager.unpack(f, b, offset);
        if (c instanceof ISOMsg) {
            this.msgPackager.unpack(c, (byte[])f.getValue());
        }
        return consumed;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        ISOBinaryField f = new ISOBinaryField(0);
        this.fieldPackager.unpack(f, in);
        if (c instanceof ISOMsg) {
            this.msgPackager.unpack(c, (byte[])f.getValue());
        }
    }

    @Override
    public ISOComponent createComponent(int fieldNumber) {
        ISOMsg m = new ISOMsg(fieldNumber);
        m.setPackager(this.msgPackager);
        return m;
    }

    @Override
    public int getMaxPackedLength() {
        return this.fieldPackager.getLength();
    }

    public ISOPackager getISOMsgPackager() {
        return this.msgPackager;
    }

    public ISOFieldPackager getISOFieldPackager() {
        return this.fieldPackager;
    }
}

