/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jpos.iso.ISOAmount;
import org.jpos.iso.ISOBasePackager;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOBinaryFieldPackager;
import org.jpos.iso.ISOBitMap;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOHeader;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOSource;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.header.BaseHeader;
import org.jpos.util.Loggeable;

public class ISOMsg
extends ISOComponent
implements Cloneable,
Loggeable,
Externalizable {
    protected Map<Integer, Object> fields = new TreeMap<Integer, Object>();
    protected int maxField = -1;
    protected ISOPackager packager;
    protected boolean dirty = true;
    protected boolean maxFieldDirty = true;
    protected int direction = 0;
    protected ISOHeader header = null;
    protected int fieldNumber = -1;
    public static final int INCOMING = 1;
    public static final int OUTGOING = 2;
    private static final long serialVersionUID = 4306251831901413975L;
    private WeakReference sourceRef;

    public ISOMsg() {
    }

    public ISOMsg(int fieldNumber) {
        this();
        this.setFieldNumber(fieldNumber);
    }

    @Override
    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    public ISOMsg(String mti) {
        this();
        try {
            this.setMTI(mti);
        }
        catch (ISOException iSOException) {
            // empty catch block
        }
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setHeader(byte[] b) {
        this.header = new BaseHeader(b);
    }

    public void setHeader(ISOHeader header) {
        this.header = header;
    }

    public byte[] getHeader() {
        return this.header != null ? this.header.pack() : null;
    }

    public ISOHeader getISOHeader() {
        return this.header;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isIncoming() {
        return this.direction == 1;
    }

    public boolean isOutgoing() {
        return this.direction == 2;
    }

    @Override
    public int getMaxField() {
        if (this.maxFieldDirty) {
            this.recalcMaxField();
        }
        return this.maxField;
    }

    private void recalcMaxField() {
        this.maxField = 0;
        for (Integer obj : this.fields.keySet()) {
            if (!(obj instanceof Integer)) continue;
            this.maxField = Math.max(this.maxField, obj);
        }
        this.maxFieldDirty = false;
    }

    public void setPackager(ISOPackager p) {
        this.packager = p;
    }

    public ISOPackager getPackager() {
        return this.packager;
    }

    @Override
    public void set(ISOComponent c) throws ISOException {
        if (c != null) {
            Integer i = (Integer)c.getKey();
            this.fields.put(i, c);
            if (i > this.maxField) {
                this.maxField = i;
            }
            this.dirty = true;
        }
    }

    public void set(int fldno, String value) throws ISOException {
        if (value != null) {
            if (!(this.packager instanceof ISOBasePackager)) {
                this.set(new ISOField(fldno, value));
            } else {
                ISOFieldPackager obj = ((ISOBasePackager)this.packager).getFieldPackager(fldno);
                if (obj instanceof ISOBinaryFieldPackager) {
                    this.set(new ISOBinaryField(fldno, ISOUtil.hex2byte(value)));
                } else {
                    this.set(new ISOField(fldno, value));
                }
            }
        } else {
            this.unset(fldno);
        }
    }

    public void set(String fpath, String value) throws ISOException {
        block3: {
            int fldno;
            StringTokenizer st = new StringTokenizer(fpath, ".");
            ISOMsg m = this;
            while (true) {
                fldno = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) break;
                Object obj = m.getValue(fldno);
                if (obj instanceof ISOMsg) {
                    m = (ISOMsg)obj;
                    continue;
                }
                if (value != null) {
                    ISOMsg iSOMsg = m;
                    m = new ISOMsg(fldno);
                    iSOMsg.set(m);
                    continue;
                }
                break block3;
                break;
            }
            m.set(fldno, value);
        }
    }

    public void set(String fpath, ISOComponent c) throws ISOException {
        block3: {
            StringTokenizer st = new StringTokenizer(fpath, ".");
            ISOMsg m = this;
            while (true) {
                int fldno = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) break;
                Object obj = m.getValue(fldno);
                if (obj instanceof ISOMsg) {
                    m = (ISOMsg)obj;
                    continue;
                }
                if (c != null) {
                    ISOMsg iSOMsg = m;
                    m = new ISOMsg(fldno);
                    iSOMsg.set(m);
                    continue;
                }
                break block3;
                break;
            }
            m.set(c);
        }
    }

    public void set(String fpath, byte[] value) throws ISOException {
        int fldno;
        StringTokenizer st = new StringTokenizer(fpath, ".");
        ISOMsg m = this;
        while (true) {
            fldno = Integer.parseInt(st.nextToken());
            if (!st.hasMoreTokens()) break;
            Object obj = m.getValue(fldno);
            if (obj instanceof ISOMsg) {
                m = (ISOMsg)obj;
                continue;
            }
            ISOMsg iSOMsg = m;
            m = new ISOMsg(fldno);
            iSOMsg.set(m);
        }
        m.set(fldno, value);
    }

    public void set(int fldno, byte[] value) throws ISOException {
        if (value != null) {
            this.set(new ISOBinaryField(fldno, value));
        } else {
            this.unset(fldno);
        }
    }

    @Override
    public void unset(int fldno) {
        if (this.fields.remove(fldno) != null) {
            this.maxFieldDirty = true;
            this.dirty = true;
        }
    }

    public void unset(int[] flds) {
        for (int fld : flds) {
            this.unset(fld);
        }
    }

    public void unset(String fpath) throws ISOException {
        block2: {
            int lastfldno;
            ISOMsg m;
            StringTokenizer st = new StringTokenizer(fpath, ".");
            ISOMsg lastm = m = this;
            int fldno = -1;
            while (true) {
                lastfldno = fldno;
                fldno = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) break;
                Object obj = m.getValue(fldno);
                if (obj instanceof ISOMsg) {
                    lastm = m;
                    m = (ISOMsg)obj;
                    continue;
                }
                break block2;
                break;
            }
            m.unset(fldno);
            if (m.hasFields() || lastfldno == -1) break block2;
            lastm.unset(lastfldno);
        }
    }

    @Override
    public ISOComponent getComposite() {
        return this;
    }

    public void recalcBitMap() throws ISOException {
        if (!this.dirty) {
            return;
        }
        int mf = Math.min(this.getMaxField(), 192);
        BitSet bmap = new BitSet(mf + 62 >> 6 << 6);
        for (int i = 1; i <= mf; ++i) {
            if (this.fields.get(i) == null) continue;
            bmap.set(i);
        }
        this.set(new ISOBitMap(-1, bmap));
        this.dirty = false;
    }

    @Override
    public Map getChildren() {
        return (Map)((TreeMap)this.fields).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] pack() throws ISOException {
        ISOMsg iSOMsg = this;
        synchronized (iSOMsg) {
            this.recalcBitMap();
            return this.packager.pack(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unpack(byte[] b) throws ISOException {
        ISOMsg iSOMsg = this;
        synchronized (iSOMsg) {
            return this.packager.unpack((ISOComponent)this, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(InputStream in) throws IOException, ISOException {
        ISOMsg iSOMsg = this;
        synchronized (iSOMsg) {
            this.packager.unpack((ISOComponent)this, in);
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.print(indent + "<" + "isomsg");
        switch (this.direction) {
            case 1: {
                p.print(" direction=\"incoming\"");
                break;
            }
            case 2: {
                p.print(" direction=\"outgoing\"");
            }
        }
        if (this.fieldNumber != -1) {
            p.print(" id=\"" + this.fieldNumber + "\"");
        }
        p.println(">");
        String newIndent = indent + "  ";
        if (this.getPackager() != null) {
            p.println(newIndent + "<!-- " + this.getPackager().getDescription() + " -->");
        }
        if (this.header instanceof Loggeable) {
            ((Loggeable)((Object)this.header)).dump(p, newIndent);
        }
        for (int i = 0; i <= this.maxField; ++i) {
            ISOComponent c = (ISOComponent)this.fields.get(i);
            if (c == null) continue;
            c.dump(p, newIndent);
        }
        p.println(indent + "</" + "isomsg" + ">");
    }

    public ISOComponent getComponent(int fldno) {
        return (ISOComponent)this.fields.get(fldno);
    }

    public Object getValue(int fldno) throws ISOException {
        ISOComponent c = this.getComponent(fldno);
        return c != null ? c.getValue() : null;
    }

    public Object getValue(String fpath) throws ISOException {
        Object obj;
        block1: {
            StringTokenizer st = new StringTokenizer(fpath, ".");
            ISOMsg m = this;
            while (true) {
                int fldno = Integer.parseInt(st.nextToken());
                obj = m.getValue(fldno);
                if (!st.hasMoreTokens()) break block1;
                if (!(obj instanceof ISOMsg)) break;
                m = (ISOMsg)obj;
            }
            throw new ISOException("Invalid path '" + fpath + "'");
        }
        return obj;
    }

    public ISOComponent getComponent(String fpath) throws ISOException {
        ISOComponent obj;
        StringTokenizer st = new StringTokenizer(fpath, ".");
        ISOMsg m = this;
        while (true) {
            int fldno = Integer.parseInt(st.nextToken());
            obj = m.getComponent(fldno);
            if (!st.hasMoreTokens() || !(obj instanceof ISOMsg)) break;
            m = (ISOMsg)obj;
        }
        return obj;
    }

    public String getString(int fldno) {
        String s = null;
        if (this.hasField(fldno)) {
            try {
                Object obj = this.getValue(fldno);
                if (obj instanceof String) {
                    s = (String)obj;
                } else if (obj instanceof byte[]) {
                    s = ISOUtil.hexString((byte[])obj);
                }
            }
            catch (ISOException iSOException) {
                // empty catch block
            }
        }
        return s;
    }

    public String getString(String fpath) {
        String s = null;
        try {
            Object obj = this.getValue(fpath);
            if (obj instanceof String) {
                s = (String)obj;
            } else if (obj instanceof byte[]) {
                s = ISOUtil.hexString((byte[])obj);
            }
        }
        catch (ISOException iSOException) {
            // empty catch block
        }
        return s;
    }

    public byte[] getBytes(int fldno) {
        byte[] b = null;
        if (this.hasField(fldno)) {
            try {
                Object obj = this.getValue(fldno);
                if (obj instanceof String) {
                    b = ((String)obj).getBytes("ISO8859_1");
                } else if (obj instanceof byte[]) {
                    b = (byte[])obj;
                }
            }
            catch (ISOException ignored) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return b;
    }

    public byte[] getBytes(String fpath) {
        byte[] b = null;
        try {
            Object obj = this.getValue(fpath);
            if (obj instanceof String) {
                b = ((String)obj).getBytes("ISO8859_1");
            } else if (obj instanceof byte[]) {
                b = (byte[])obj;
            }
        }
        catch (ISOException ignored) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return b;
    }

    public boolean hasField(int fldno) {
        return this.fields.get(fldno) != null;
    }

    public boolean hasFields(int[] fields) {
        for (int field : fields) {
            if (this.hasField(field)) continue;
            return false;
        }
        return true;
    }

    public boolean hasField(String fpath) throws ISOException {
        int fldno;
        ISOMsg m;
        block1: {
            StringTokenizer st = new StringTokenizer(fpath, ".");
            m = this;
            while (true) {
                fldno = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) break block1;
                Object obj = m.getValue(fldno);
                if (!(obj instanceof ISOMsg)) break;
                m = (ISOMsg)obj;
            }
            return false;
        }
        return m.hasField(fldno);
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Override
    public void setValue(Object obj) throws ISOException {
        throw new ISOException("setValue N/A in ISOMsg");
    }

    public Object clone() {
        try {
            ISOMsg m = (ISOMsg)super.clone();
            m.fields = (TreeMap)((TreeMap)this.fields).clone();
            if (this.header != null) {
                m.header = (ISOHeader)this.header.clone();
            }
            for (Integer k : this.fields.keySet()) {
                ISOComponent c = (ISOComponent)m.fields.get(k);
                if (!(c instanceof ISOMsg)) continue;
                m.fields.put(k, ((ISOMsg)c).clone());
            }
            return m;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone(int[] fields) {
        try {
            ISOMsg m = (ISOMsg)super.clone();
            m.fields = new TreeMap<Integer, Object>();
            for (int field : fields) {
                if (!this.hasField(field)) continue;
                try {
                    m.set(this.getComponent(field));
                }
                catch (ISOException e) {
                    // empty catch block
                }
            }
            return m;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void merge(ISOMsg m) {
        for (int i = 0; i <= m.getMaxField(); ++i) {
            try {
                if (!m.hasField(i)) continue;
                this.set(m.getComponent(i));
                continue;
            }
            catch (ISOException iSOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.isIncoming()) {
            s.append("<-- ");
        } else if (this.isOutgoing()) {
            s.append("--> ");
        } else {
            s.append("    ");
        }
        s.append(this.getString(0));
        if (this.hasField(11)) {
            s.append(' ');
            s.append(this.getString(11));
        }
        if (this.hasField(41)) {
            s.append(' ');
            s.append(this.getString(41));
        }
        return s.toString();
    }

    @Override
    public Object getKey() throws ISOException {
        if (this.fieldNumber != -1) {
            return this.fieldNumber;
        }
        throw new ISOException("This is not a subField");
    }

    @Override
    public Object getValue() {
        return this;
    }

    public boolean isInner() {
        return this.fieldNumber > -1;
    }

    public void setMTI(String mti) throws ISOException {
        if (this.isInner()) {
            throw new ISOException("can't setMTI on inner message");
        }
        this.set(new ISOField(0, mti));
    }

    public void move(int oldFieldNumber, int newFieldNumber) throws ISOException {
        ISOComponent c = this.getComponent(oldFieldNumber);
        this.unset(oldFieldNumber);
        if (c != null) {
            c.setFieldNumber(newFieldNumber);
            this.set(c);
        } else {
            this.unset(newFieldNumber);
        }
    }

    public String getMTI() throws ISOException {
        if (this.isInner()) {
            throw new ISOException("can't getMTI on inner message");
        }
        if (!this.hasField(0)) {
            throw new ISOException("MTI not available");
        }
        return (String)this.getValue(0);
    }

    public boolean isRequest() throws ISOException {
        return Character.getNumericValue(this.getMTI().charAt(2)) % 2 == 0;
    }

    public boolean isResponse() throws ISOException {
        return !this.isRequest();
    }

    public boolean isRetransmission() throws ISOException {
        return this.getMTI().charAt(3) == '1';
    }

    public void setResponseMTI() throws ISOException {
        if (!this.isRequest()) {
            throw new ISOException("not a request - can't set response MTI");
        }
        String mti = this.getMTI();
        char c1 = mti.charAt(3);
        char c2 = '0';
        switch (c1) {
            case '0': 
            case '1': {
                c2 = '0';
                break;
            }
            case '2': 
            case '3': {
                c2 = '2';
                break;
            }
            case '4': 
            case '5': {
                c2 = '4';
            }
        }
        this.set(new ISOField(0, mti.substring(0, 2) + (Character.getNumericValue(this.getMTI().charAt(2)) + 1) + c2));
    }

    public void setRetransmissionMTI() throws ISOException {
        if (!this.isRequest()) {
            throw new ISOException("not a request");
        }
        this.set(new ISOField(0, this.getMTI().substring(0, 3) + "1"));
    }

    protected void writeHeader(ObjectOutput out) throws IOException {
        int len = this.header.getLength();
        if (len > 0) {
            out.writeByte(72);
            out.writeShort(len);
            out.write(this.header.pack());
        }
    }

    protected void readHeader(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] b = new byte[in.readShort()];
        in.readFully(b);
        this.setHeader(b);
    }

    protected void writePackager(ObjectOutput out) throws IOException {
        out.writeByte(80);
        String pclass = this.packager.getClass().getName();
        byte[] b = pclass.getBytes();
        out.writeShort(b.length);
        out.write(b);
    }

    protected void readPackager(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] b = new byte[in.readShort()];
        in.readFully(b);
        try {
            Class<?> mypClass = Class.forName(new String(b));
            ISOPackager myp = (ISOPackager)mypClass.newInstance();
            this.setPackager(myp);
        }
        catch (Exception e) {
            this.setPackager(null);
        }
    }

    protected void writeDirection(ObjectOutput out) throws IOException {
        out.writeByte(68);
        out.writeByte(this.direction);
    }

    protected void readDirection(ObjectInput in) throws IOException, ClassNotFoundException {
        this.direction = in.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeShort(this.fieldNumber);
        if (this.header != null) {
            this.writeHeader(out);
        }
        if (this.packager != null) {
            this.writePackager(out);
        }
        if (this.direction > 0) {
            this.writeDirection(out);
        }
        for (Object o : this.fields.values()) {
            ISOComponent c = (ISOComponent)o;
            if (c instanceof ISOMsg) {
                this.writeExternal(out, 'M', c);
                continue;
            }
            if (c instanceof ISOBinaryField) {
                this.writeExternal(out, 'B', c);
                continue;
            }
            if (c instanceof ISOAmount) {
                this.writeExternal(out, 'A', c);
                continue;
            }
            if (!(c instanceof ISOField)) continue;
            this.writeExternal(out, 'F', c);
        }
        out.writeByte(69);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.fieldNumber = in.readShort();
        try {
            byte fieldType;
            while ((fieldType = in.readByte()) != 69) {
                ISOComponent c = null;
                switch (fieldType) {
                    case 70: {
                        c = new ISOField();
                        break;
                    }
                    case 65: {
                        c = new ISOAmount();
                        break;
                    }
                    case 66: {
                        c = new ISOBinaryField();
                        break;
                    }
                    case 77: {
                        c = new ISOMsg();
                        break;
                    }
                    case 72: {
                        this.readHeader(in);
                        break;
                    }
                    case 80: {
                        this.readPackager(in);
                        break;
                    }
                    case 68: {
                        this.readDirection(in);
                        break;
                    }
                    default: {
                        throw new IOException("malformed ISOMsg");
                    }
                }
                if (c == null) continue;
                ((Externalizable)((Object)c)).readExternal(in);
                this.set(c);
            }
        }
        catch (ISOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setSource(ISOSource source) {
        this.sourceRef = new WeakReference<ISOSource>(source);
    }

    public ISOSource getSource() {
        return this.sourceRef != null ? (ISOSource)this.sourceRef.get() : null;
    }

    private void writeExternal(ObjectOutput out, char b, ISOComponent c) throws IOException {
        out.writeByte(b);
        ((Externalizable)((Object)c)).writeExternal(out);
    }
}

