/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOVError;
import org.jpos.iso.ISOVField;
import org.jpos.iso.ISOValidator;
import org.jpos.iso.validator.ISOVException;

public class ISOFieldValidator
implements Configurable,
ISOValidator {
    protected String description;
    protected int fieldId;
    protected int minLen = 0;
    protected int maxLen = 999999;
    protected boolean breakOnError = false;
    protected Configuration cfg;

    public ISOFieldValidator() {
        this.description = "";
    }

    public ISOFieldValidator(String Description) {
        this.description = Description;
    }

    public ISOFieldValidator(int maxLen, String Description) {
        this.description = Description;
        this.minLen = 0;
        this.maxLen = maxLen;
    }

    public ISOFieldValidator(int minLen, int maxLen, String Description) {
        this.description = Description;
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    public ISOFieldValidator(boolean breakOnError, int minLen, int maxLen, String Description) {
        this(minLen, maxLen, Description);
        this.breakOnError = breakOnError;
    }

    public ISOFieldValidator(boolean breakOnError, int maxLen, String Description) {
        this(maxLen, Description);
        this.breakOnError = breakOnError;
    }

    public ISOFieldValidator(boolean breakOnError, String Description) {
        this(Description);
        this.breakOnError = breakOnError;
    }

    public ISOFieldValidator(boolean breakOnError) {
        this();
        this.breakOnError = breakOnError;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.minLen = cfg.getInt("min-len", 0);
        this.maxLen = cfg.getInt("max-len", 999999);
        this.breakOnError = cfg.getBoolean("break-on-error", false);
    }

    public void setMaxLength(int maxLen) {
        this.maxLen = maxLen;
    }

    public void setMinLength(int minLen) {
        this.minLen = minLen;
    }

    public void setBreakOnError(boolean breakOnErr) {
        this.breakOnError = breakOnErr;
    }

    public boolean breakOnError() {
        return this.breakOnError;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFieldId(int f) {
        this.fieldId = f;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public String getRejCode(int ErrType) {
        return null;
    }

    @Override
    public ISOComponent validate(ISOComponent c) throws ISOException {
        ISOField f = (ISOField)c;
        Object v = f.getValue();
        int l = 0;
        if (v instanceof byte[]) {
            l = ((byte[])v).length;
        } else if (v instanceof String) {
            l = ((String)v).length();
        }
        if (l < this.minLen || l > this.maxLen) {
            ISOVError e = new ISOVError("Invalid Length Error. Length must be in [" + this.minLen + ", " + this.maxLen + "]. (Current len: " + l + ") ", this.getRejCode(1));
            if (f instanceof ISOVField) {
                ((ISOVField)f).addISOVError(e);
            } else {
                f = new ISOVField(f, e);
            }
            if (this.breakOnError) {
                throw new ISOVException("Error on field " + f.getKey(), f);
            }
        }
        return f;
    }
}

