/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;

public abstract class ISOFieldPackager {
    private int len;
    private String description;
    protected boolean pad;

    public ISOFieldPackager() {
        this.len = -1;
        this.description = null;
    }

    public ISOFieldPackager(int len, String description) {
        this.len = len;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getLength() {
        return this.len;
    }

    public void setLength(int len) {
        this.len = len;
    }

    public void setPad(boolean pad) {
        this.pad = pad;
    }

    public abstract int getMaxPackedLength();

    public ISOComponent createComponent(int fieldNumber) {
        return new ISOField(fieldNumber);
    }

    public abstract byte[] pack(ISOComponent var1) throws ISOException;

    public abstract int unpack(ISOComponent var1, byte[] var2, int var3) throws ISOException;

    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        this.unpack(c, this.readBytes(in, this.getMaxPackedLength()), 0);
    }

    public void pack(ISOComponent c, ObjectOutput out) throws IOException, ISOException {
        out.write(this.pack(c));
    }

    protected byte[] readBytes(InputStream in, int l) throws IOException {
        int count;
        byte[] b = new byte[l];
        for (int n = 0; n < l; n += count) {
            count = in.read(b, n, l - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return b;
    }
}

