/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class ISOField
extends ISOComponent
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = -4053616930139887829L;
    protected int fieldNumber;
    protected String value;

    public ISOField() {
        this.fieldNumber = -1;
    }

    public ISOField(int n) {
        this.fieldNumber = n;
    }

    public ISOField(int n, String v) {
        this.fieldNumber = n;
        this.value = v;
    }

    @Override
    public byte[] pack() throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public int unpack(byte[] b) throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public void unpack(InputStream in) throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public Object getKey() {
        return this.fieldNumber;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object obj) throws ISOException {
        this.value = obj instanceof String ? (String)obj : obj.toString();
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.value != null ? this.value.getBytes("ISO8859_1") : new byte[]{};
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        if (this.value != null && this.value.indexOf(60) >= 0) {
            p.print(indent + "<" + "field" + " " + "id" + "=\"" + this.fieldNumber + "\"><![CDATA[");
            p.print(this.value);
            p.println("]]></field>");
        } else {
            p.println(indent + "<" + "field" + " " + "id" + "=\"" + this.fieldNumber + "\" " + "value" + "=\"" + ISOUtil.normalize(this.value) + "\"/>");
        }
    }

    @Override
    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fieldNumber);
        out.writeUTF(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldNumber = in.readShort();
        this.value = in.readUTF();
    }
}

