/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISODate {
    public static final long ONE_YEAR = 31536000000L;

    private ISODate() {
        throw new AssertionError();
    }

    public static String formatDate(Date d, String pattern) {
        return ISODate.formatDate(d, pattern, TimeZone.getDefault());
    }

    public static String formatDate(Date d, String pattern, TimeZone timeZone) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        df.setTimeZone(timeZone);
        df.applyPattern(pattern);
        return df.format(d);
    }

    public static Date parse(String s) {
        return ISODate.parse(s, TimeZone.getDefault());
    }

    public static Date parse(String s, TimeZone timeZone) {
        Date d = null;
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.UK);
        df.setTimeZone(timeZone);
        try {
            d = df.parse(s);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return d;
    }

    public static Date parseDateTime(String s) {
        return ISODate.parseDateTime(s, TimeZone.getDefault());
    }

    public static Date parseDateTime(String s, TimeZone timeZone) {
        Date d = null;
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, Locale.UK);
        df.setTimeZone(timeZone);
        try {
            d = df.parse(s);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return d;
    }

    public static Date parseISODate(String d) {
        return ISODate.parseISODate(d, System.currentTimeMillis());
    }

    public static Date parseISODate(String d, TimeZone timeZone) {
        return ISODate.parseISODate(d, System.currentTimeMillis(), timeZone);
    }

    public static Date parseISODate(String d, long currentTime) {
        return ISODate.parseISODate(d, currentTime, TimeZone.getDefault());
    }

    public static Date parseISODate(String d, long currentTime, TimeZone timeZone) {
        int YY = 0;
        if (d.length() == 14) {
            YY = Integer.parseInt(d.substring(0, 4));
            d = d.substring(4);
        } else if (d.length() == 12) {
            YY = 2000 + Integer.parseInt(d.substring(0, 2));
            d = d.substring(2);
        }
        int MM = Integer.parseInt(d.substring(0, 2)) - 1;
        int DD = Integer.parseInt(d.substring(2, 4));
        int hh = Integer.parseInt(d.substring(4, 6));
        int mm = Integer.parseInt(d.substring(6, 8));
        int ss = Integer.parseInt(d.substring(8, 10));
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(timeZone);
        Date now = new Date(currentTime);
        cal.setTime(now);
        cal.set(2, MM);
        cal.set(5, DD);
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, 0);
        if (YY != 0) {
            cal.set(1, YY);
            return cal.getTime();
        }
        Date thisYear = cal.getTime();
        cal.set(1, cal.get(1) - 1);
        Date previousYear = cal.getTime();
        cal.set(1, cal.get(1) + 2);
        Date nextYear = cal.getTime();
        if (Math.abs(now.getTime() - previousYear.getTime()) < Math.abs(now.getTime() - thisYear.getTime())) {
            thisYear = previousYear;
        } else if (Math.abs(now.getTime() - thisYear.getTime()) > Math.abs(now.getTime() - nextYear.getTime())) {
            thisYear = nextYear;
        }
        return thisYear;
    }

    public static String getDateTime(Date d) {
        return ISODate.formatDate(d, "MMddHHmmss");
    }

    public static String getDateTime(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "MMddHHmmss", timeZone);
    }

    public static String getTime(Date d) {
        return ISODate.formatDate(d, "HHmmss");
    }

    public static String getTime(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "HHmmss", timeZone);
    }

    public static String getDate(Date d) {
        return ISODate.formatDate(d, "MMdd");
    }

    public static String getDate(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "MMdd", timeZone);
    }

    public static String getANSIDate(Date d) {
        return ISODate.formatDate(d, "yyMMdd");
    }

    public static String getANSIDate(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "yyMMdd", timeZone);
    }

    public static String getEuropeanDate(Date d) {
        return ISODate.formatDate(d, "ddMMyy");
    }

    public static String getEuropeanDate(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "ddMMyy", timeZone);
    }

    public static String getExpirationDate(Date d) {
        return ISODate.formatDate(d, "yyMM");
    }

    public static String getExpirationDate(Date d, TimeZone timeZone) {
        return ISODate.formatDate(d, "yyMM", timeZone);
    }

    public static String getJulianDate(Date d) {
        String day = ISODate.formatDate(d, "DDD", TimeZone.getDefault());
        String year = ISODate.formatDate(d, "yy", TimeZone.getDefault());
        year = year.substring(1);
        return year + day;
    }

    public static String getJulianDate(Date d, TimeZone timeZone) {
        String day = ISODate.formatDate(d, "DDD", timeZone);
        String year = ISODate.formatDate(d, "yy", timeZone);
        year = year.substring(1);
        return year + day;
    }
}

