/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.jpos.iso.Currency;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class ISOCurrency {
    private static Map<String, Currency> currencies;
    private static final Object mutex;

    private ISOCurrency() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPropertiesFromClasspath(String base) {
        InputStream in = ISOCurrency.loadResourceAsStream(base);
        try {
            if (in != null) {
                ISOCurrency.addBundle(new PropertyResourceBundle(in));
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static double convertFromIsoMsg(String isoamount, String currency) throws IllegalArgumentException {
        Currency c = ISOCurrency.findCurrency(currency);
        return c.parseAmountFromISOMsg(isoamount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBundle(ResourceBundle r) {
        Object object = mutex;
        synchronized (object) {
            Enumeration<String> en = r.getKeys();
            while (en.hasMoreElements()) {
                String alphaCode = en.nextElement();
                String[] tmp = r.getString(alphaCode).split(" ");
                String isoCode = tmp[0];
                int numDecimals = Integer.parseInt(tmp[1]);
                ISOCurrency.addCurrency(alphaCode, isoCode, numDecimals);
            }
        }
    }

    public static void addBundle(String bundleName) {
        ResourceBundle r = ResourceBundle.getBundle(bundleName);
        ISOCurrency.addBundle(r);
    }

    public static String convertToIsoMsg(double amount, String currency) throws IllegalArgumentException {
        return ISOCurrency.findCurrency(currency).formatAmountForISOMsg(amount);
    }

    public static Object[] decomposeComposedCurrency(String incurr) throws IllegalArgumentException {
        String[] strings = incurr.split(" ");
        if (strings.length != 2) {
            throw new IllegalArgumentException("Invalid parameter: " + incurr);
        }
        return new Object[]{strings[0], Double.valueOf(strings[1])};
    }

    public static String getIsoCodeFromAlphaCode(String alphacode) throws IllegalArgumentException {
        try {
            Currency c = ISOCurrency.findCurrency(alphacode);
            return ISOUtil.zeropad(Integer.toString(c.getIsoCode()), 3);
        }
        catch (ISOException e) {
            throw new IllegalArgumentException("Failed getIsoCodeFromAlphaCode/ zeropad failed?", e);
        }
    }

    public static Currency getCurrency(int code) throws ISOException {
        String isoCode = ISOUtil.zeropad(Integer.toString(code), 3);
        return ISOCurrency.findCurrency(isoCode);
    }

    public static Currency getCurrency(String code) throws ISOException {
        String isoCode = ISOUtil.zeropad(code, 3);
        return ISOCurrency.findCurrency(isoCode);
    }

    private static InputStream loadResourceAsStream(String name) {
        InputStream in = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            in = contextClassLoader.getResourceAsStream(name);
        }
        if (in == null) {
            in = ISOCurrency.class.getClassLoader().getResourceAsStream(name);
        }
        return in;
    }

    private static void addCurrency(String alphaCode, String isoCode, int numDecimals) {
        if (currencies.containsKey(alphaCode) || currencies.containsKey(isoCode)) {
            currencies.remove(alphaCode);
            currencies.remove(isoCode);
        }
        Currency ccy = new Currency(alphaCode, Integer.parseInt(isoCode), numDecimals);
        currencies.put(alphaCode, ccy);
        currencies.put(isoCode, ccy);
    }

    private static Currency findCurrency(String currency) {
        Currency c = currencies.get(currency.toUpperCase());
        if (c == null) {
            throw new IllegalArgumentException("Currency with key '" + currency + "' was not found");
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = mutex = new Object();
        synchronized (object) {
            currencies = new HashMap<String, Currency>();
        }
        ISOCurrency.addBundle(ISOCurrency.class.getName());
        ISOCurrency.loadPropertiesFromClasspath("META-INF/org/jpos/config/ISOCurrency.properties");
    }
}

