/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.BinaryInterpreter;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.LiteralBinaryInterpreter;
import org.jpos.iso.NullPrefixer;
import org.jpos.iso.Prefixer;

public class ISOBinaryFieldPackager
extends ISOFieldPackager {
    private BinaryInterpreter interpreter;
    private Prefixer prefixer;

    public ISOBinaryFieldPackager() {
        this.interpreter = LiteralBinaryInterpreter.INSTANCE;
        this.prefixer = NullPrefixer.INSTANCE;
    }

    public ISOBinaryFieldPackager(int maxLength, String description, BinaryInterpreter interpreter, Prefixer prefixer) {
        super(maxLength, description);
        this.interpreter = interpreter;
        this.prefixer = prefixer;
    }

    public ISOBinaryFieldPackager(BinaryInterpreter interpreter, Prefixer prefixer) {
        this.interpreter = interpreter;
        this.prefixer = prefixer;
    }

    public void setInterpreter(BinaryInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setPrefixer(Prefixer prefixer) {
        this.prefixer = prefixer;
    }

    @Override
    public int getMaxPackedLength() {
        return this.prefixer.getPackedLength() + this.interpreter.getPackedLength(this.getLength());
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        try {
            byte[] data = c.getBytes();
            int packedLength = this.prefixer.getPackedLength();
            if (packedLength == 0 && data.length != this.getLength()) {
                throw new ISOException("Binary data length not the same as the packager length (" + data.length + "/" + this.getLength() + ")");
            }
            byte[] ret = new byte[this.interpreter.getPackedLength(data.length) + packedLength];
            this.prefixer.encodeLength(data.length, ret);
            this.interpreter.interpret(data, ret, packedLength);
            return ret;
        }
        catch (Exception e) {
            throw new ISOException(this.makeExceptionMessage(c, "packing"), e);
        }
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        try {
            int len = this.prefixer.decodeLength(b, offset);
            if (len == -1) {
                len = this.getLength();
            } else if (this.getLength() > 0 && len > this.getLength()) {
                throw new ISOException("Field length " + len + " too long. Max: " + this.getLength());
            }
            int lenLen = this.prefixer.getPackedLength();
            byte[] unpacked = this.interpreter.uninterpret(b, offset + lenLen, len);
            c.setValue(unpacked);
            return lenLen + this.interpreter.getPackedLength(len);
        }
        catch (Exception e) {
            throw new ISOException(this.makeExceptionMessage(c, "unpacking"), e);
        }
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        try {
            int len;
            int lenLen = this.prefixer.getPackedLength();
            if (lenLen == 0) {
                len = this.getLength();
            } else {
                len = this.prefixer.decodeLength(this.readBytes(in, lenLen), 0);
                if (this.getLength() > 0 && len > 0 && len > this.getLength()) {
                    throw new ISOException("Field length " + len + " too long. Max: " + this.getLength());
                }
            }
            int packedLen = this.interpreter.getPackedLength(len);
            byte[] unpacked = this.interpreter.uninterpret(this.readBytes(in, packedLen), 0, len);
            c.setValue(unpacked);
        }
        catch (ISOException e) {
            throw new ISOException(this.makeExceptionMessage(c, "unpacking"), e);
        }
    }

    @Override
    public ISOComponent createComponent(int fieldNumber) {
        return new ISOBinaryField(fieldNumber);
    }

    private String makeExceptionMessage(ISOComponent c, String operation) {
        Object fieldKey = "unknown";
        if (c != null) {
            try {
                fieldKey = c.getKey();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return this.getClass().getName() + ": Problem " + operation + " field " + fieldKey;
    }

    protected void checkLength(int len, int maxLength) throws IllegalArgumentException {
        if (len > maxLength) {
            throw new IllegalArgumentException("Length " + len + " too long for " + this.getClass().getName());
        }
    }
}

