/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class ISOBinaryField
extends ISOComponent
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 7702505828876640372L;
    protected int fieldNumber;
    protected byte[] value;

    public ISOBinaryField() {
        this.fieldNumber = -1;
    }

    public ISOBinaryField(int n) {
        this.fieldNumber = n;
    }

    public ISOBinaryField(int n, byte[] v) {
        this.fieldNumber = n;
        this.value = v;
    }

    public ISOBinaryField(int n, byte[] v, int offset, int len) {
        byte[] b = new byte[len];
        System.arraycopy(v, offset, b, 0, len);
        this.fieldNumber = n;
        this.value = b;
    }

    @Override
    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    @Override
    public byte[] pack() throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public int unpack(byte[] b) throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public void unpack(InputStream in) throws ISOException {
        throw new ISOException("Not available on Leaf");
    }

    @Override
    public Object getKey() {
        return this.fieldNumber;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object obj) throws ISOException {
        this.value = obj instanceof String ? ((String)obj).getBytes() : (byte[])obj;
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + "<" + "field" + " " + "id" + "=\"" + this.fieldNumber + "\" " + "value" + "=\"" + this.toString() + "\" " + "type" + "=\"" + "binary" + "\"/>");
    }

    public String toString() {
        return ISOUtil.hexString(this.value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fieldNumber);
        out.writeShort(this.value.length);
        out.write(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldNumber = in.readShort();
        this.value = new byte[in.readShort()];
        in.readFully(this.value);
    }
}

