/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.jpos.iso.ISOBitMap;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOMsgFieldPackager;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;

public abstract class ISOBasePackager
implements ISOPackager,
LogSource {
    protected ISOFieldPackager[] fld;
    protected Logger logger = null;
    protected String realm = null;
    protected int headerLength = 0;

    public void setFieldPackager(ISOFieldPackager[] fld) {
        this.fld = fld;
    }

    protected boolean emitBitMap() {
        return this.fld[1] instanceof ISOBitMapPackager;
    }

    protected int getFirstField() {
        if (!(this.fld[0] instanceof ISOMsgFieldPackager) && this.fld.length > 1) {
            return this.fld[1] instanceof ISOBitMapPackager ? 2 : 1;
        }
        return 0;
    }

    @Override
    public byte[] pack(ISOComponent m) throws ISOException {
        LogEvent evt = null;
        if (this.logger != null) {
            evt = new LogEvent(this, "pack");
        }
        try {
            byte[] h;
            int i;
            byte[] b;
            byte[] h2;
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            ArrayList<byte[]> v = new ArrayList<byte[]>(128);
            Map fields = m.getChildren();
            int len = 0;
            int first = this.getFirstField();
            ISOComponent c = (ISOComponent)fields.get(0);
            if (m instanceof ISOMsg && this.headerLength > 0 && (h2 = ((ISOMsg)m).getHeader()) != null) {
                len += h2.length;
            }
            if (first > 0 && c != null) {
                b = this.fld[0].pack(c);
                len += b.length;
                v.add(b);
            }
            if (this.emitBitMap()) {
                c = (ISOComponent)fields.get(-1);
                b = this.getBitMapfieldPackager().pack(c);
                len += b.length;
                v.add(b);
            }
            int tmpMaxField = Math.min(m.getMaxField(), 128);
            for (i = first; i <= tmpMaxField; ++i) {
                c = (ISOComponent)fields.get(i);
                if (c == null) continue;
                try {
                    ISOFieldPackager fp = this.fld[i];
                    if (fp == null) {
                        throw new ISOException("null field " + i + " packager");
                    }
                    b = fp.pack(c);
                    len += b.length;
                    v.add(b);
                    continue;
                }
                catch (ISOException e) {
                    if (evt != null) {
                        evt.addMessage("error packing field " + i);
                        evt.addMessage(c);
                        evt.addMessage(e);
                    }
                    throw new ISOException("error packing field " + i, e);
                }
            }
            if (m.getMaxField() > 128 && this.fld.length > 128) {
                for (i = 1; i <= 64; ++i) {
                    c = (ISOComponent)fields.get(i + 128);
                    if (c == null) continue;
                    try {
                        b = this.fld[i + 128].pack(c);
                        len += b.length;
                        v.add(b);
                        continue;
                    }
                    catch (ISOException e) {
                        if (evt != null) {
                            evt.addMessage("error packing field " + (i + 128));
                            evt.addMessage(c);
                            evt.addMessage(e);
                        }
                        throw e;
                    }
                }
            }
            int k = 0;
            byte[] d = new byte[len];
            if (m instanceof ISOMsg && this.headerLength > 0 && (h = ((ISOMsg)m).getHeader()) != null) {
                System.arraycopy(h, 0, d, k, h.length);
                k += h.length;
            }
            for (byte[] bb : v) {
                System.arraycopy(bb, 0, d, k, bb.length);
                k += bb.length;
            }
            if (evt != null) {
                evt.addMessage(ISOUtil.hexString(d));
            }
            byte[] byArray = d;
            return byArray;
        }
        catch (ISOException e) {
            if (evt != null) {
                evt.addMessage(e);
            }
            throw e;
        }
        finally {
            if (evt != null) {
                Logger.log(evt);
            }
        }
    }

    @Override
    public int unpack(ISOComponent m, byte[] b) throws ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        int consumed = 0;
        try {
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            if (this.logger != null) {
                evt.addMessage(ISOUtil.hexString(b));
            }
            if (m instanceof ISOMsg && this.headerLength > 0) {
                byte[] h = new byte[this.headerLength];
                System.arraycopy(b, 0, h, 0, this.headerLength);
                ((ISOMsg)m).setHeader(h);
                consumed += this.headerLength;
            }
            if (this.fld[0] != null && !(this.fld[0] instanceof ISOBitMapPackager)) {
                ISOComponent mti = this.fld[0].createComponent(0);
                consumed += this.fld[0].unpack(mti, b, consumed);
                m.set(mti);
            }
            BitSet bmap = null;
            int maxField = this.fld.length;
            if (this.emitBitMap()) {
                ISOBitMap bitmap = new ISOBitMap(-1);
                consumed += this.getBitMapfieldPackager().unpack(bitmap, b, consumed);
                bmap = (BitSet)bitmap.getValue();
                if (this.logger != null) {
                    evt.addMessage("<bitmap>" + bmap.toString() + "</bitmap>");
                }
                m.set(bitmap);
                maxField = Math.min(maxField, bmap.size());
            }
            for (int i = this.getFirstField(); i < maxField; ++i) {
                try {
                    if (bmap == null && this.fld[i] == null || maxField > 128 && i == 65 || bmap != null && !bmap.get(i)) continue;
                    if (this.fld[i] == null) {
                        throw new ISOException("field packager '" + i + "' is null");
                    }
                    ISOComponent c = this.fld[i].createComponent(i);
                    consumed += this.fld[i].unpack(c, b, consumed);
                    if (this.logger != null) {
                        evt.addMessage("<unpack fld=\"" + i + "\" packager=\"" + this.fld[i].getClass().getName() + "\">");
                        if (c.getValue() instanceof ISOMsg) {
                            evt.addMessage(c.getValue());
                        } else if (c.getValue() instanceof byte[]) {
                            evt.addMessage("  <value type='binary'>" + ISOUtil.hexString((byte[])c.getValue()) + "</value>");
                        } else {
                            evt.addMessage("  <value>" + c.getValue() + "</value>");
                        }
                        evt.addMessage("</unpack>");
                    }
                    m.set(c);
                    continue;
                }
                catch (ISOException e) {
                    evt.addMessage("error unpacking field " + i + " consumed=" + consumed);
                    evt.addMessage(e);
                    e = new ISOException(String.format("%s (%s) unpacking field=%d, consumed=%d", e.getMessage(), e.getNested().toString(), i, consumed));
                    throw e;
                }
            }
            if (b.length != consumed) {
                evt.addMessage("WARNING: unpack len=" + b.length + " consumed=" + consumed);
            }
            int n = consumed;
            return n;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException(e.getMessage() + " consumed=" + consumed);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public void unpack(ISOComponent m, InputStream in) throws IOException, ISOException {
        LogEvent evt = new LogEvent(this, "unpack");
        try {
            ISOComponent c;
            int i;
            if (m.getComposite() != m) {
                throw new ISOException("Can't call packager on non Composite");
            }
            if (m instanceof ISOMsg && ((ISOMsg)m).getHeader() == null && this.headerLength > 0) {
                byte[] h = new byte[this.headerLength];
                in.read(h, 0, this.headerLength);
                ((ISOMsg)m).setHeader(h);
            }
            if (!(this.fld[0] instanceof ISOMsgFieldPackager) && !(this.fld[0] instanceof ISOBitMapPackager)) {
                ISOComponent mti = this.fld[0].createComponent(0);
                this.fld[0].unpack(mti, in);
                m.set(mti);
            }
            BitSet bmap = null;
            int maxField = this.fld.length;
            if (this.emitBitMap()) {
                ISOBitMap bitmap = new ISOBitMap(-1);
                this.getBitMapfieldPackager().unpack(bitmap, in);
                bmap = (BitSet)bitmap.getValue();
                if (this.logger != null) {
                    evt.addMessage("<bitmap>" + bmap.toString() + "</bitmap>");
                }
                m.set(bitmap);
                maxField = Math.min(maxField, bmap.size());
            }
            for (i = this.getFirstField(); i < maxField; ++i) {
                if (bmap == null && this.fld[i] == null || bmap != null && !bmap.get(i)) continue;
                if (this.fld[i] == null) {
                    throw new ISOException("field packager '" + i + "' is null");
                }
                c = this.fld[i].createComponent(i);
                this.fld[i].unpack(c, in);
                if (this.logger != null) {
                    evt.addMessage("<unpack fld=\"" + i + "\" packager=\"" + this.fld[i].getClass().getName() + "\">");
                    if (c.getValue() instanceof ISOMsg) {
                        evt.addMessage(c.getValue());
                    } else {
                        evt.addMessage("  <value>" + c.getValue().toString() + "</value>");
                    }
                    evt.addMessage("</unpack>");
                }
                m.set(c);
            }
            if (bmap != null && bmap.get(65) && this.fld.length > 128 && this.fld[65] instanceof ISOBitMapPackager) {
                bmap = (BitSet)((ISOComponent)m.getChildren().get(65)).getValue();
                for (i = 1; i < 64; ++i) {
                    if (bmap != null && !bmap.get(i)) continue;
                    c = this.fld[i + 128].createComponent(i);
                    this.fld[i + 128].unpack(c, in);
                    if (this.logger != null) {
                        evt.addMessage("<unpack fld=\"" + i + 128 + "\" packager=\"" + this.fld[i + 128].getClass().getName() + "\">");
                        evt.addMessage("  <value>" + c.getValue().toString() + "</value>");
                        evt.addMessage("</unpack>");
                    }
                    m.set(c);
                }
            }
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    @Override
    public String getFieldDescription(ISOComponent m, int fldNumber) {
        return this.fld[fldNumber].getDescription();
    }

    public ISOFieldPackager getFieldPackager(int fldNumber) {
        return this.fld != null && fldNumber < this.fld.length ? this.fld[fldNumber] : null;
    }

    public void setFieldPackager(int fldNumber, ISOFieldPackager fieldPackager) {
        this.fld[fldNumber] = fieldPackager;
    }

    @Override
    public ISOMsg createISOMsg() {
        return new ISOMsg();
    }

    protected int getMaxValidField() {
        return 128;
    }

    protected ISOFieldPackager getBitMapfieldPackager() {
        return this.fld[1];
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int len) {
        this.headerLength = len;
    }

    @Override
    public String getDescription() {
        return this.getClass().getName();
    }
}

