/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.math.BigDecimal;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOCurrency;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class ISOAmount
extends ISOComponent
implements Cloneable,
Externalizable {
    static final long serialVersionUID = -6130248734056876225L;
    private int fieldNumber;
    private int currencyCode;
    private String value;
    private BigDecimal amount;

    public ISOAmount() {
        this.setFieldNumber(-1);
    }

    public ISOAmount(int fieldNumber) {
        this.setFieldNumber(fieldNumber);
    }

    public ISOAmount(int fieldNumber, int currencyCode, BigDecimal amount) throws ISOException {
        this.setFieldNumber(fieldNumber);
        this.amount = amount.setScale(ISOCurrency.getCurrency(currencyCode).getDecimals());
        this.currencyCode = currencyCode;
    }

    @Override
    public Object getKey() {
        return this.fieldNumber;
    }

    @Override
    public Object getValue() throws ISOException {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ISOUtil.zeropad(Integer.toString(this.currencyCode), 3));
            sb.append(Integer.toString(this.amount.scale()));
            sb.append(ISOUtil.zeropad(this.amount.movePointRight(this.amount.scale()).toString(), 12));
            this.value = sb.toString();
        }
        return this.value;
    }

    @Override
    public void setValue(Object obj) throws ISOException {
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() < 12) {
                throw new ISOException("ISOAmount invalid length " + s.length());
            }
            try {
                this.currencyCode = Integer.parseInt(s.substring(0, 3));
                int dec = Integer.parseInt(s.substring(3, 4));
                this.amount = new BigDecimal(s.substring(4)).movePointLeft(dec);
                this.value = s;
            }
            catch (NumberFormatException e) {
                throw new ISOException(e.getMessage());
            }
        }
    }

    @Override
    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public int getScale() {
        return this.amount.scale() % 10;
    }

    public String getScaleAsString() {
        return Integer.toString(this.getScale());
    }

    public int getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencyCodeAsString() throws ISOException {
        return ISOUtil.zeropad(Integer.toString(this.currencyCode), 3);
    }

    public String getAmountAsLegacyString() throws ISOException {
        return ISOUtil.zeropad(this.amount.unscaledValue().toString(), 12);
    }

    public String getAmountAsString() throws ISOException {
        StringBuilder sb = new StringBuilder(16);
        sb.append(ISOUtil.zeropad(Integer.toString(this.currencyCode), 3));
        sb.append(Integer.toString(this.amount.scale() % 10));
        sb.append(ISOUtil.zeropad(this.amount.unscaledValue().toString(), 12));
        return sb.toString();
    }

    @Override
    public byte[] pack() throws ISOException {
        throw new ISOException("Not available");
    }

    @Override
    public int unpack(byte[] b) throws ISOException {
        throw new ISOException("Not available");
    }

    @Override
    public void unpack(InputStream in) throws ISOException {
        throw new ISOException("Not available");
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + "<" + "field" + " " + "id" + "=\"" + this.fieldNumber + "\" " + "currency=\"" + ISOUtil.zeropad(this.currencyCode, 3) + "\" " + "type" + "=\"amount\" " + "value" + "=\"" + this.amount.toString() + "\"/>");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fieldNumber);
        try {
            out.writeUTF((String)this.getValue());
        }
        catch (ISOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldNumber = in.readShort();
        try {
            this.setValue(in.readUTF());
        }
        catch (ISOException e) {
            throw new IOException(e.getMessage());
        }
    }
}

