/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class IFE_BITMAP
extends ISOBitMapPackager {
    public IFE_BITMAP() {
    }

    public IFE_BITMAP(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        int lastBitOn;
        BitSet bitMapValue = (BitSet)c.getValue();
        int maxBytesPossible = this.getLength();
        int maxBitsAllowedPhysically = maxBytesPossible << 3;
        int actualLastBit = lastBitOn = bitMapValue.length() - 1;
        if (lastBitOn > 128) {
            actualLastBit = bitMapValue.get(65) ? 192 : 128;
        } else if (lastBitOn > 64) {
            actualLastBit = bitMapValue.get(1) ? 128 : 64;
        }
        if (actualLastBit > maxBitsAllowedPhysically) {
            throw new ISOException("Bitmap can only hold bits numbered up to " + maxBitsAllowedPhysically + " in the " + this.getLength() + " bytes available.");
        }
        int requiredLengthInBytes = (actualLastBit >> 3) + (actualLastBit % 8 > 0 ? 1 : 0);
        int requiredBitMapLengthInBytes = requiredLengthInBytes > 4 && requiredLengthInBytes <= 8 ? 8 : (requiredLengthInBytes > 8 && requiredLengthInBytes <= 16 ? 16 : (requiredLengthInBytes > 16 && requiredLengthInBytes <= 24 ? 24 : maxBytesPossible));
        byte[] b = ISOUtil.bitSet2byte(bitMapValue, requiredBitMapLengthInBytes);
        return ISOUtil.asciiToEbcdic(ISOUtil.hexString(b).getBytes());
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() >> 2;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        byte[] b1 = ISOUtil.ebcdicToAsciiBytes(b, offset, this.getLength() * 2);
        BitSet bmap = ISOUtil.hex2BitSet(b1, 0, this.getLength() << 3);
        c.setValue(bmap);
        int bytes = b1.length;
        if (bytes > 16 && !bmap.get(1)) {
            bytes = 16;
        } else if (bytes > 32 && !bmap.get(65)) {
            bytes = 32;
        }
        return bytes;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        byte[] b1 = ISOUtil.ebcdicToAsciiBytes(this.readBytes(in, 16), 0, 16);
        BitSet bmap = ISOUtil.hex2BitSet(new BitSet(64), b1, 0);
        if (this.getLength() > 8 && bmap.get(1)) {
            byte[] b2 = ISOUtil.ebcdicToAsciiBytes(this.readBytes(in, 16), 0, 16);
            ISOUtil.hex2BitSet(bmap, b2, 64);
        }
        c.setValue(bmap);
    }
}

