/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOField;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFEP_LLCHAR
extends ISOFieldPackager {
    public IFEP_LLCHAR() {
    }

    public IFEP_LLCHAR(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        String s = (String)c.getValue();
        int len = s.length();
        if (len > this.getLength() || len > 97) {
            throw new ISOException("invalid len " + len + " packing IFEP_LLCHAR field " + c.getKey());
        }
        return (ISOUtil.zeropad(Integer.toString(len + 2), 2) + ISOUtil.zeropad(c.getKey().toString(), 2) + s).getBytes();
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len = Integer.parseInt(new String(b, offset, 2));
        if (!(c instanceof ISOField)) {
            throw new ISOException(c.getClass().getName() + " is not an ISOField");
        }
        c.setFieldNumber(Integer.parseInt(new String(b, offset + 2, 2)));
        c.setValue(new String(b, offset + 4, len - 2));
        return len + 2;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        if (!(c instanceof ISOField)) {
            throw new ISOException(c.getClass().getName() + " is not an ISOField");
        }
        int len = Integer.parseInt(new String(this.readBytes(in, 2)));
        int fldno = Integer.parseInt(new String(this.readBytes(in, 2)));
        c.setFieldNumber(fldno);
        c.setValue(new String(this.readBytes(in, len - 2)));
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() + 2;
    }
}

