/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFEB_LLNUM
extends ISOFieldPackager {
    public IFEB_LLNUM() {
    }

    public IFEB_LLNUM(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        boolean odd = false;
        String s = (String)c.getValue();
        int len = s.length();
        if (len > this.getLength() || len > 99) {
            throw new ISOException("invalid len " + len + " packing IFEB_LLNUM field " + c.getKey());
        }
        if (len % 2 == 1) {
            odd = true;
            len = len / 2 + 1;
        } else {
            odd = false;
            len /= 2;
        }
        String fieldLength = ISOUtil.zeropad(Integer.toString(len), 2);
        byte[] EBCDIClength = ISOUtil.asciiToEbcdic(fieldLength);
        byte[] bcd = ISOUtil.str2bcd(s, false);
        if (odd) {
            bcd[len - 1] = (byte)(bcd[len - 1] | 0xF);
        }
        byte[] b = new byte[bcd.length + 2];
        b[0] = EBCDIClength[0];
        b[1] = EBCDIClength[1];
        System.arraycopy(bcd, 0, b, 2, bcd.length);
        return b;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        boolean pad = false;
        int len = (b[offset] & 0xF) * 10 + (b[offset + 1] & 0xF);
        int tempLen = len * 2;
        byte lastByte = b[offset + 2 + len - 1];
        if ((lastByte & 0xF) == 15) {
            --tempLen;
        }
        c.setValue(ISOUtil.bcd2str(b, offset + 2, tempLen, pad));
        return len + 2;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        byte[] b = this.readBytes(in, 2);
        int len = 100 * (((b[0] >> 4 & 0xF) > 9 ? 0 : b[0] >> 4 & 0xF) * 10 + (b[0] & 0xF)) + ((b[1] >> 4 & 0xF) > 9 ? 0 : b[1] >> 4 & 0xF) * 10 + (b[1] & 0xF);
        c.setValue(ISOUtil.bcd2str(this.readBytes(in, len), 0, 2 * len, this.pad));
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() + 2;
    }
}

