/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFEB_LLLNUM
extends ISOFieldPackager {
    public IFEB_LLLNUM() {
    }

    public IFEB_LLLNUM(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        boolean odd = false;
        String s = (String)c.getValue();
        int len = s.length();
        if (len > this.getLength() || len > 99) {
            throw new ISOException("invalid len " + len + " packing IFEB_LLLNUM field " + c.getKey());
        }
        if (len % 2 == 1) {
            odd = true;
            len = len / 2 + 1;
        } else {
            odd = false;
            len /= 2;
        }
        String fieldLength = ISOUtil.zeropad(Integer.toString(len), 3);
        byte[] EBCDIClength = ISOUtil.asciiToEbcdic(fieldLength);
        byte[] bcd = ISOUtil.str2bcd(s, false);
        if (odd) {
            bcd[len - 1] = (byte)(bcd[len - 1] | 0xF);
        }
        byte[] b = new byte[bcd.length + 3];
        b[0] = EBCDIClength[0];
        b[1] = EBCDIClength[1];
        b[2] = EBCDIClength[2];
        System.arraycopy(bcd, 0, b, 3, bcd.length);
        return b;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        boolean pad = false;
        int len = (b[offset] & 0xF) * 100 + (b[offset + 1] & 0xF) * 10 + (b[offset + 2] & 0xF);
        int tempLen = len * 2;
        byte testByte = b[offset + 3 + len - 1];
        if ((testByte | 0xF0) == 255) {
            --tempLen;
        }
        c.setValue(ISOUtil.bcd2str(b, offset + 3, tempLen, pad));
        return len + 3;
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() + 3;
    }
}

