/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;

public class IFB_LLHFBINARY
extends ISOFieldPackager {
    public IFB_LLHFBINARY() {
    }

    public IFB_LLHFBINARY(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        int len = ((byte[])c.getValue()).length;
        if (len > this.getLength() || len > 255) {
            throw new ISOException("invalid len " + len + " packing field " + c.getKey());
        }
        byte[] b = new byte[this.getLength() + 1];
        b[0] = (byte)len;
        System.arraycopy(c.getValue(), 0, b, 1, len);
        return b;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len = b[offset] & 0xFF;
        byte[] value = new byte[len];
        System.arraycopy(b, ++offset, value, 0, len);
        c.setValue(value);
        return this.getLength() + 1;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        byte[] b = this.readBytes(in, 1);
        int len = b[0] & 0xFF;
        c.setValue(this.readBytes(in, len));
        in.skip(this.getLength() - len);
    }

    @Override
    public ISOComponent createComponent(int fieldNumber) {
        return new ISOBinaryField(fieldNumber);
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() + 1;
    }
}

