/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class IFB_BITMAP
extends ISOBitMapPackager {
    public IFB_BITMAP() {
    }

    public IFB_BITMAP(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        BitSet b = (BitSet)c.getValue();
        int len = this.getLength() >= 8 ? b.length() + 62 >> 6 << 3 : this.getLength();
        return ISOUtil.bitSet2byte(b, len);
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len;
        BitSet bmap = ISOUtil.byte2BitSet(b, offset, this.getLength() << 3);
        c.setValue(bmap);
        int n = len = bmap.get(1) ? 128 : 64;
        if (this.getLength() > 16 && bmap.get(65)) {
            len = 192;
        }
        return Math.min(this.getLength(), len >> 3);
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        BitSet bmap = ISOUtil.byte2BitSet(new BitSet(64), this.readBytes(in, 8), 0);
        if (this.getLength() > 8 && bmap.get(1)) {
            ISOUtil.byte2BitSet(bmap, this.readBytes(in, 8), 64);
        }
        if (this.getLength() > 16 && bmap.get(65)) {
            ISOUtil.byte2BitSet(bmap, this.readBytes(in, 8), 128);
        }
        c.setValue(bmap);
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() >> 3;
    }
}

