/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.BCDInterpreter;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFB_AMOUNT
extends ISOFieldPackager {
    private BCDInterpreter interpreter;

    public IFB_AMOUNT() {
        this.interpreter = BCDInterpreter.LEFT_PADDED;
    }

    public IFB_AMOUNT(int len, String description, boolean pad) {
        super(len, description);
        this.pad = pad;
        this.interpreter = pad ? BCDInterpreter.LEFT_PADDED : BCDInterpreter.RIGHT_PADDED;
    }

    @Override
    public void setPad(boolean pad) {
        this.pad = pad;
        this.interpreter = pad ? BCDInterpreter.LEFT_PADDED : BCDInterpreter.RIGHT_PADDED;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        String s = (String)c.getValue();
        String amount = ISOUtil.zeropad(s.substring(1), this.getLength() - 1);
        byte[] b = new byte[1 + (this.getLength() >> 1)];
        b[0] = (byte)s.charAt(0);
        this.interpreter.interpret(amount, b, 1);
        return b;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        String d = new String(b, offset, 1) + this.interpreter.uninterpret(b, offset + 1, this.getLength() - 1);
        c.setValue(d);
        return 1 + (this.getLength() >> 1);
    }

    @Override
    public int getMaxPackedLength() {
        return 1 + (this.getLength() >> 1);
    }
}

