/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFA_LLLABINARY
extends ISOFieldPackager {
    public IFA_LLLABINARY() {
    }

    public IFA_LLLABINARY(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        byte[] b = (byte[])c.getValue();
        int len = b.length;
        if (len > this.getLength() || len > 999) {
            throw new ISOException("invalid len " + len + " packing IFA_LLLABINARY field " + c.getKey());
        }
        byte[] data = ISOUtil.hexString((byte[])c.getValue()).getBytes();
        byte[] nb = new byte[3 + data.length];
        byte[] length = new DecimalFormat("000").format(len).getBytes();
        System.arraycopy(length, 0, nb, 0, 3);
        System.arraycopy(data, 0, nb, 3, data.length);
        return nb;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len = Integer.parseInt(new String(b, offset, 3));
        c.setValue(ISOUtil.hex2byte(b, offset + 3, len));
        return len * 2 + 3;
    }

    @Override
    public ISOComponent createComponent(int fieldNumber) {
        return new ISOBinaryField(fieldNumber);
    }

    @Override
    public int getMaxPackedLength() {
        return (this.getLength() << 1) + 3;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        int len = Integer.parseInt(new String(this.readBytes(in, 3)));
        c.setValue(this.readBytes(in, len));
    }
}

