/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import org.jpos.iso.AsciiPrefixer;
import org.jpos.iso.BCDInterpreter;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.Interpreter;
import org.jpos.iso.Prefixer;

public class IFA_LLBNUM
extends ISOFieldPackager {
    private Interpreter interpreter;
    private Prefixer prefixer;

    public IFA_LLBNUM() {
        this.interpreter = BCDInterpreter.LEFT_PADDED;
        this.prefixer = AsciiPrefixer.LL;
    }

    public IFA_LLBNUM(int len, String description, boolean pad) {
        super(len, description);
        this.pad = pad;
        this.interpreter = pad ? BCDInterpreter.LEFT_PADDED : BCDInterpreter.RIGHT_PADDED;
        this.prefixer = AsciiPrefixer.LL;
    }

    @Override
    public void setPad(boolean pad) {
        this.pad = pad;
        this.interpreter = pad ? BCDInterpreter.LEFT_PADDED : BCDInterpreter.RIGHT_PADDED;
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        String s = (String)c.getValue();
        int len = s.length();
        if (len > this.getLength() || len > 99) {
            throw new ISOException("invalid len " + len + " packing IFA_LLBNUM field " + c.getKey());
        }
        byte[] b = new byte[3 + (len >> 1)];
        this.prefixer.encodeLength(len + 1 >> 1 << 1, b);
        this.interpreter.interpret(s, b, 2);
        return b;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len = this.prefixer.decodeLength(b, offset);
        c.setValue(this.interpreter.uninterpret(b, offset + 2, len));
        return 2 + (++len >> 1);
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        int len = this.prefixer.decodeLength(this.readBytes(in, 2), 2);
        c.setValue(this.interpreter.uninterpret(this.readBytes(in, len + 2 >> 1), 0, len));
    }

    @Override
    public int getMaxPackedLength() {
        return 1 + (this.getLength() + 1 >> 1);
    }
}

