/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.jpos.iso.ISOBinaryField;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFieldPackager;
import org.jpos.iso.ISOUtil;

public class IFA_LLABINARY
extends ISOFieldPackager {
    public IFA_LLABINARY() {
    }

    public IFA_LLABINARY(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        byte[] b = (byte[])c.getValue();
        int len = b.length;
        if (len > this.getLength() || len > 99) {
            throw new ISOException("invalid len " + len + " packing field " + c.getKey());
        }
        byte[] data = ISOUtil.hexString((byte[])c.getValue()).getBytes();
        byte[] nb = new byte[2 + data.length];
        byte[] length = new DecimalFormat("00").format(len).getBytes();
        System.arraycopy(length, 0, nb, 0, 2);
        System.arraycopy(data, 0, nb, 2, data.length);
        return nb;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len = Integer.parseInt(new String(b, offset, 2));
        c.setValue(ISOUtil.hex2byte(b, offset + 2, len));
        return len * 2 + 2;
    }

    @Override
    public ISOComponent createComponent(int fieldNumber) {
        return new ISOBinaryField(fieldNumber);
    }

    @Override
    public int getMaxPackedLength() {
        return (this.getLength() << 1) + 2;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        int len = Integer.parseInt(new String(this.readBytes(in, 2)));
        c.setValue(this.readBytes(in, len));
    }
}

